% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arrange-rd.R, R/arrange.R
\name{arrange.duckplyr_df}
\alias{arrange.duckplyr_df}
\title{Order rows using column values}
\usage{
\method{arrange}{duckplyr_df}(.data, ..., .by_group = FALSE, .locale = NULL)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> Variables, or
functions of variables. Use \code{\link[dplyr:desc]{desc()}} to sort a variable in descending
order.}

\item{.by_group}{If \code{TRUE}, will sort first by grouping variable. Applies to
grouped data frames only.}

\item{.locale}{The locale to sort character vectors in.
\itemize{
\item If \code{NULL}, the default, uses the \code{"C"} locale unless the
\code{dplyr.legacy_locale} global option escape hatch is active. See the
\link[dplyr]{dplyr-locale} help page for more details.
\item If a single string from \code{\link[stringi:stri_locale_list]{stringi::stri_locale_list()}} is supplied, then
this will be used as the locale to sort with. For example, \code{"en"} will
sort with the American English locale. This requires the stringi package.
\item If \code{"C"} is supplied, then character vectors will always be sorted in the
C locale. This does not require stringi and is often much faster than
supplying a locale identifier.
}

The C locale is not the same as English locales, such as \code{"en"},
particularly when it comes to data containing a mix of upper and lower case
letters. This is explained in more detail on the \link[dplyr:dplyr-locale]{locale}
help page under the \verb{Default locale} section.}
}
\description{
This is a method for the \code{\link[dplyr:arrange]{dplyr::arrange()}} generic.
See "Fallbacks" section for differences in implementation.
\code{arrange()} orders the rows of a data frame by the values of selected
columns.

Unlike other dplyr verbs, \code{arrange()} largely ignores grouping; you
need to explicitly mention grouping variables (or use  \code{.by_group = TRUE})
in order to group by them, and functions of variables are evaluated
once per data frame, not once per group.
}
\section{Fallbacks}{

There is no DuckDB translation in \code{arrange.duckplyr_df()}
\itemize{
\item with \code{.by_group = TRUE},
\item providing a value for the \code{.locale} argument,
\item providing a value for the \code{dplyr.legacy_locale} option.
}

These features fall back to \code{\link[dplyr:arrange]{dplyr::arrange()}}, see \code{vignette("fallback")} for details.
}

\examples{
library(duckplyr)
arrange(mtcars, cyl, disp)
arrange(mtcars, desc(disp))
}
\seealso{
\code{\link[dplyr:arrange]{dplyr::arrange()}}
}
