% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_filter.R
\name{ddbs_intersection}
\alias{ddbs_intersection}
\title{Calculates the intersection of two geometries}
\usage{
ddbs_intersection(
  conn,
  x,
  y,
  name = NULL,
  crs = NULL,
  crs_column = "crs_duckspatial",
  overwrite = NULL
)
}
\arguments{
\item{conn}{a connection object to a DuckDB database}

\item{x}{a table with geometry column within the DuckDB database. Data is returned
from this object}

\item{y}{a table with geometry column within the DuckDB database}

\item{name}{a character string of length one specifying the name of the table,
or a character string of length two specifying the schema and table names. If it's
NULL (the default), it will return the result as an \code{sf} object}

\item{crs}{the coordinates reference system of the data. Specify if the data
doesn't have crs_column, and you know the crs}

\item{crs_column}{a character string of length one specifying the column
storing the CRS (created automatically by \code{\link{ddbs_write_vector}}). Set
to NULL if absent}

\item{overwrite}{whether to overwrite the existing table if it exists. Ignored
when name is NULL}
}
\value{
an sf object or TRUE (invisibly) for table creation
}
\description{
Calculates the intersection of two geometries, and return a \code{sf} object
}
\examples{
\donttest{
## load packages
library(duckdb)
library(duckspatial)
library(sf)

## database setup
conn <- dbConnect(duckdb())
ddbs_install(conn)
ddbs_load(conn)

## read data
countries_sf <- st_read(system.file("spatial/countries.geojson", package = "duckspatial"))
argentina_sf <- st_read(system.file("spatial/argentina.geojson", package = "duckspatial"))

## store in duckdb
ddbs_write_vector(conn, countries_sf, "countries")
ddbs_write_vector(conn, argentina_sf, "argentina")

## intersection
ddbs_intersection(conn, "countries", "argentina")
}
}
