% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duration.R
\name{mphcrm.control}
\alias{mphcrm.control}
\title{Control parameters for mphcrm}
\usage{
mphcrm.control(...)
}
\arguments{
\item{...}{parameters that can be adjusted. See the \code{vignette("whatmph")} for more details.
\itemize{
\item threads. integer. The number of threads to use. Defaults to \code{getOption('durmod.threads')}.
\item iters. integer. How many iterations should we maximally run. Defaults to 12.
\item ll.improve. numeric. How much must the log-likelihood improve from the last iteration before
  termination. Defaults to 0.001.
\item newpoint.maxtime. numeric. For how many seconds should a global search for a new point
  improving the likelihood be conducted before we continue with the best we have found. Defaults to
  120.
\item callback. A
  user-specified \code{function(fromwhere, opt, dataset, control,
  ...)} which is called after each optimization step.  It can be
  used to report what is happening, check whatever it wants, and
  optionally stop the estimation by calling stop(). In this case,
  \code{mphcrm()} will return with the most recently estimated set
  of parameters. See the help on \code{\link{mphcrm.callback}} for
  information on the argument.
\item trap.interrupt. logical. Should interrupts be trapped so that \code{mphcrm} returns gracefully?
In this case the program will continue. Defaults to \code{interactive()}.
\item cluster. Cluster specification from package \pkg{parallel} or \pkg{snow}.
}}
}
\value{
List of control parameters suitable for the \code{control}
  argument of \code{\link{mphcrm}}.
}
\description{
Modify the default estimation parameters for
  \code{\link{mphcrm}}.
}
\note{
There are more parameters documented in the \code{vignette("whatmph")}. Some of them
can be useful. Instead of cluttering
the source code with constants and stuff required by various optimization routines, they
have been put in this control list.
}
