% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document_universe.R
\name{document_universe}
\alias{document_universe}
\title{Create a data frame with documentation metadata of one or more packages}
\usage{
document_universe(x, url_template = NULL)
}
\arguments{
\item{x}{A character vector giving concepts or package names to match.}

\item{url_template}{Character. A template to generate links to documentation
based on the column names of the output -- typically \code{package} and \code{topic},
e.g. \code{"https://maurolepore.github.io/{package}/reference/{topic}.html"}
(\code{glue::glue()} syntax).}
}
\value{
A data frame.
}
\description{
Create a data.frame with documentation metadata of one or more packages. If
you develop a universe, such as the tidyverse or tidymodels, dverse helps you
to easily create a universe-wide reference for the pkgdown website of your
meta-package.
}
\examples{
library(glue)
library(tibble)

url_template <- "https://{package}.tidyverse.org/reference/{topic}.html"
document_universe(c("glue", "tibble"), url_template)
}
