% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generatePairings.R
\name{generatePairings}
\alias{generatePairings}
\title{Sex-consistent pairings}
\usage{
generatePairings(pm, am, missing, includeEmpty = TRUE, ignoreSex = FALSE)
}
\arguments{
\item{pm}{A list of singletons.}

\item{am}{A list of pedigrees.}

\item{missing}{Character vector with names of missing persons.}

\item{includeEmpty}{A logical. If TRUE (default), the do-nothing symbol (\code{*})
is included for each victim.}

\item{ignoreSex}{A logical.}
}
\value{
A list of character vectors. Each vector is a subset of \code{missing},
plus the character \code{*} denoting no pairing.
}
\description{
Generate a list of sex-consistent pairings for each victim in a DVI problem.
By default, the empty pairing (denoted \code{*}) is included for each victim.
}
\examples{

pm = list(singleton("V1", sex = 1),
          singleton("V2", sex = 2))

missing = paste0("M", 1:4)
am = list(nuclearPed(children = missing[1:3]),
          nuclearPed(children = missing[4], sex = 2))
generatePairings(pm, am, missing)

}
\seealso{
\code{\link[=jointDVI]{jointDVI()}}
}
