% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jointDVI.R
\name{jointDVI}
\alias{jointDVI}
\title{Joint DVI search}
\usage{
jointDVI(
  pm,
  am,
  missing,
  pairings = NULL,
  ignoreSex = FALSE,
  assignments = NULL,
  limit = 0,
  undisputed = TRUE,
  markers = NULL,
  threshold = 10000,
  relax = FALSE,
  disableMutations = NA,
  numCores = 1,
  check = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{pm}{A list of singletons.}

\item{am}{A list of pedigrees.}

\item{missing}{Character vector with names of missing persons.}

\item{pairings}{A list of possible pairings for each victim. If NULL, all
sex-consistent pairings are used.}

\item{ignoreSex}{A logical.}

\item{assignments}{A data frame containing the assignments to be considered
in the joint analysis. By default, this is automatically generated by
taking all combinations from \code{pairings}.}

\item{limit}{A positive number, by default 0. Only pairwise LR values above
this are considered.}

\item{undisputed}{A logical, by default TRUE.}

\item{markers}{A vector indicating which markers should be included in the
analysis. By default all markers are included.}

\item{threshold}{A positive number, passed onto \code{\link[=findUndisputed]{findUndisputed()}}. Default:
1e4.}

\item{relax}{A logical, passed onto \code{\link[=findUndisputed]{findUndisputed()}}. Default: FALSE.}

\item{disableMutations}{A logical, or NA (default). The default action is to
disable mutations in all reference families without Mendelian errors.}

\item{numCores}{Integer. The number of cores used in parallelisation.
Default: 1.}

\item{check}{A logical, indicating if the input data should be checked for
consistency.}

\item{verbose}{A logical.}
}
\value{
A data frame. Each row describes an assignment of victims to missing
persons, accompanied with its log likelihood, the LR compared to the null
(i.e., no identifications), and the posterior corresponding to a flat
prior.
}
\description{
Victims are given as a list of singletons, and references as a list of
pedigrees. All possible assignments are evaluated and solutions ranked
according to the likelihood.
}
\examples{
pm = example2$pm
am = example2$am
missing = example2$missing

jointDVI(pm, am, missing)

}
\seealso{
\code{\link[=pairwiseLR]{pairwiseLR()}}, \code{\link[=findUndisputed]{findUndisputed()}}
}
