% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{combineSummaries}
\alias{combineSummaries}
\title{Combine summary tables}
\usage{
combineSummaries(dfs, orderBy = NULL, dvi = NULL)
}
\arguments{
\item{dfs}{A list of data frames.}

\item{orderBy}{A character with column names to sort by.}

\item{dvi}{A \code{dviData} object used for sorting. Note that if given, this must
contain all victims and families.}
}
\value{
A data frame.
}
\description{
Combines summary tables from various functions into a final result table.
}
\examples{
u = findUndisputed(planecrash)
a = amDrivenDVI(u$dviReduced, threshold2 = 500)

u$summary
a$summary

combineSummaries(list(u$summary, a$summary),
                 orderBy = c("Family", "Missing"),
                 dvi = planecrash)
}
