% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/truerange.R
\name{truerange}
\alias{truerange}
\title{Range of a Vector (Not Min/Max!)}
\usage{
truerange(x, integer = FALSE)
}
\arguments{
\item{x}{Integer or numeric vector.}

\item{integer}{Logical value for whether \code{x} is an integer vector.}
}
\value{
Integer or numeric value.
}
\description{
The base R function \code{\link[base]{range}} returns the minimum and maximum 
of a vector, but the "range" is actually defined as the difference between 
the minimum and maximum. This function calculates the actual range. It is 
equivalent to the base R code \code{diff(range(x))}, but a bit simpler and 
much faster.
}
\examples{
# truerange vs. diff(range()) for integer vector
x <- rpois(1000, lambda = 5)
all.equal(diff(range(x)), truerange(x, TRUE))
benchmark(diff(range(x)), truerange(x, TRUE), replications = 2000)

# truerange vs. diff(range()) for numeric vector
x <- rnorm(1000)
all.equal(diff(range(x)), truerange(x))
benchmark(diff(range(x)), truerange(x), replications = 2000)


}
