% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_request.R
\name{project_create_request}
\alias{project_create_request}
\title{Create request object for new projects.}
\usage{
project_create_request(title, visibility = c("PRIVATE", "OPEN"),
  objective = NULL, summary = NULL, tags = character(), license = NULL,
  files = list(), linked_datasets = list())
}
\arguments{
\item{title}{Project title.}

\item{visibility}{Project visibility, must be PRIVATE or OPEN.}

\item{objective}{(optional) Short project objective.}

\item{summary}{(optional) Long-form project summary (Markdown supported).}

\item{tags}{Character vector of project tags (letters, numbers and spaces).}

\item{license}{Dataset license ("Public Domain", "PDDL", "CC-0",
"CC-BY", "ODC-BY", "CC-BY-SA", "ODC-ODbL", "CC BY-NC-SA" or Other).}

\item{files}{(optional) List of \code{\link{file_create_request}} objects.}

\item{linked_datasets}{List of
\code{\link{linked_dataset_create_or_update_request}} objects.}
}
\value{
Request object of type \code{project_create_request}.
}
\description{
Create request object for new projects.
}
\examples{
request <- dwapi::project_create_request(title='My Project', visibility = 'OPEN',
  objective = 'objective', tags = c('sdk') , license = 'Public Domain')
}
\seealso{
\code{\link{create_project}}
}
