% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fun_Extract-simulation.R
\name{ext.output}
\alias{ext.output}
\title{Extract simulations from DYRESM-CAEDYM output.}
\usage{
ext.output(
  dycd.output = "data/dysim.nc",
  var.extract = c("TEMP", "DO", "TP", "TN", "NO3", "NH4", "CHLA")
)
}
\arguments{
\item{dycd.output}{a string of characters of the output netcdf file names of DYRESM-CAEDYM model}

\item{var.extract}{a vector of variables to be extracted from the output file.
Options include TEMP, DO, TP, NO3, NH4, TN, CHLA, FDIAT, SSOL1, SSOL2, and PO4.
Apart from nominated variables, simulation period and layer height data are also extracted.
For a full list of variables that can be extracted, use "data("output_name")".}
}
\value{
a list of values of those variables of interest,
   as well as two compulsory variables (i.e. simulation period, water level)
}
\description{
Extract simulations from DYRESM-CAEDYM output. It is recommended to use the following example code to
assign values of each simulated variable to a corresponding matrix.
}
\examples{
 # extract simulated temperature values from DYRESM-CAEDYM simulation file
 var.values<-ext.output(dycd.output=system.file("extdata", "dysim.nc", package = "dycdtools"),
                       var.extract=c("TEMP"))

 for(i in 1:length(var.values)){
  expres<-paste0(names(var.values)[i],"<-data.frame(var.values[[",i,"]])")
  eval(parse(text=expres))
 }

}
