% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamac.R
\name{dynardl.all.plots}
\alias{dynardl.all.plots}
\title{Combine all of the potential plots of a simulated response in a \code{\link{dynardl}} model}
\usage{
dynardl.all.plots(x, type = "area", bw = FALSE, last.period = NULL,
  start.period = 1, tol = (abs(x$model$ymean) * 0.01),
  abs.errors = "none", ylim = NULL, xlab = NULL, ylab = NULL, ...)
}
\arguments{
\item{x}{a \code{dynardl} model with a simulation to be plotted. Since all plots includes absolute cumulative differences, \code{fullsims} must be \code{TRUE} in the \code{dynardl} simulation}

\item{type}{whether the plot should be an area plot (\code{area}) or a spike plot (\code{spike})}

\item{bw}{should the colors be in black and white (for publication)? The default is \code{FALSE}}

\item{last.period}{when deciding when to stop calculating the absolute value of the shocks to the dependent variable, you can specify a specific period in which to stop calculating absolute cumulative differences. Specify a \code{tol} or a \code{last.period}. If both are specified, \code{last.period} overrides \code{tol}}

\item{start.period}{which period of the simulation to begin the plot with. You can view the equilibriating behavior of the dependent variable, or you can skip forward in time (maybe to just before the shock). The default is \code{1} (the first period of the simulation)}

\item{tol}{when deciding when to stop calculating the absolute value of the shocks to the dependent variable, you can specify the minimum amount of movement required to qualify as a non-noise change over time periods (for calculating absolute cumulative differences). The default is 0.1 percent of the mean of the dependent variable. Specify a \code{tol} or a \code{last.period}. If both are specified, \code{last.period} overrides \code{tol}}

\item{abs.errors}{when calculating confidence for the absolute cumulative effect, should differences accumulate in each time time period (\code{cumulate}, which could be explosive if the error in the model is large), should differences be observed at each time (\code{within.period}, which will have smaller values in equilibrium than when changing), or should only the values be plotted (\code{none})}

\item{ylim}{a user-defined y-limit to be used instead of the default (for instance, for shared axes. Use caution, as it will be passed to all plots)}

\item{xlab}{a user-defined x-label to be used instead of the default (use caution, as it will be passed to all plots)}

\item{ylab}{a user-defined y-label to be used instead of the default (use caution, as it will be passed to all plots)}

\item{...}{other arguments to be passed to the call to plot. Use caution, as they will be passed to all plots}
}
\value{
a 2 x 3 grid of the plots of the simulated dynardl model effects plots
}
\description{
Combine all of the potential plots of a simulated response in a \code{\link{dynardl}} model
}
\details{
When running \code{dynardl}, \code{simulate} must be \code{TRUE} so that there is a simulation to plot. Also, \code{fullsims} must be \code{TRUE} as the plot will contain absolute cumulative differences. See \code{\link{dynardl.simulation.plot}} for arguments to the individual plotting types
}
\examples{
# Using the ineq data in dynamac
# Shocking Income Top 10
set.seed(1)
ardl.model <- dynardl(concern ~ incshare10 + urate, data = ineq, 
       lags = list("concern" = 1, "incshare10" = 1),
       diffs = c("incshare10", "urate"), 
       lagdiffs = list("concern" = 1),
       ec = TRUE, simulate = TRUE, range = 30,
       shockvar = "incshare10", fullsims = TRUE)

# Shows all of the potential responses
dynardl.all.plots(ardl.model)	
# Same plot, but with spikeplot
dynardl.all.plots(ardl.model, type = "spike")  
# Grayscale plots
dynardl.all.plots(ardl.model, bw = TRUE)	 
}
\author{
Soren Jordan and Andrew Q. Philips
}
\keyword{utilities}
