% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamac.R
\name{dynardl.simulation.plot}
\alias{dynardl.simulation.plot}
\title{Create a plot of a simulated response in a dynardl model}
\usage{
dynardl.simulation.plot(x, type = "area", response = "levels",
  bw = FALSE, y.lab = "", x.lab = "")
}
\arguments{
\item{x}{a dynardl model with a simulation to be plotted}

\item{type}{whether the plot should be an area plot (\code{area}) or a spike plot (\code{spike})}

\item{response}{whether the plot of the response should be shown in levels of the dependent variable (\code{levels}), 
changes from the mean of the dependent variable (\code{levels.from.mean}), period-over-period changes in the
dependent variable (\code{diffs}), the sum of the period-over-period changes (\code{cumulative.diffs}), or the absolute
value of the cumulative differences (\code{cumulative.abs.diffs}). The default is \code{levels}}

\item{bw}{should the colors be in black and white (for publication)? The default is \code{FALSE}}

\item{y.lab}{a user-defined y-label to be used instead of the default}

\item{x.lab}{a user-defined x-label to be used instead of the default}
}
\value{
a plot of the simulated dynardl model
}
\description{
Create a plot of a simulated response in a dynardl model
}
\details{
When running \code{dynardl}, \code{simulate} must be true so that there is a simulation to plot.
}
\examples{
# Using the ineq data in dynamac
# Shocking Income Top 10
ardl.model <- dynardl(concern ~ incshare10 + urate, data = ineq, 
       lags = list("concern" = 1, "incshare10" = 1),
       diffs = c("incshare10", "urate"), 
       lagdiffs = list("concern" = 1),
       ec = TRUE, simulate = TRUE, range = 30,
       shockvar = "incshare10")

# Shows absolute levels
dynardl.simulation.plot(ardl.model)	
# Shows changes from mean level
dynardl.simulation.plot(ardl.model, response = "levels.from.mean")  
# Same plot, but with spikeplot
dynardl.simulation.plot(ardl.model, type = "spike", response = "levels.from.mean")  
# Grayscale plots
dynardl.simulation.plot(ardl.model, bw = TRUE)	 
}
\author{
Soren Jordan and Andrew Q. Philips
}
\keyword{utilities}
