% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamice.R
\name{mice.impute.lead}
\alias{mice.impute.lead}
\title{Compute Leading Values of an Imputed Response}
\usage{
mice.impute.lead(y, ry, x, wy = NULL, group_val, group_var, resp, ...)
}
\arguments{
\item{y}{Vector to be imputed}

\item{ry}{Logical vector of length \code{length(y)} indicating the
the subset \code{y[ry]} of elements in \code{y} to which the imputation
model is fitted. The \code{ry} generally distinguishes the observed
(\code{TRUE}) and missing values (\code{FALSE}) in \code{y}.}

\item{x}{Numeric design matrix with \code{length(y)} rows with predictors for
\code{y}. Matrix \code{x} may have no missing values.}

\item{wy}{Logical vector of length \code{length(y)}. A \code{TRUE} value
indicates locations in \code{y} for which imputations are created.}

\item{group_val}{[\code{vector()}]\cr Values of the grouping variable.}

\item{group_var}{[\code{character(1)}]\cr Name of the grouping variable.}

\item{resp}{[\code{character(1)}]\cr Name of the response variable.}

\item{...}{Other named arguments.}
}
\description{
Function for computing the leading values of an imputed response in \code{mice}.
}
\keyword{internal}
