% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_chans.R
\name{build_chans}
\alias{build_chans}
\title{Construct a raster of channel locations from vector or topographic data}
\usage{
build_chans(dem, drn, chan.width = 1, atb = NULL, buffer = 10,
  atb.thresh = 0.8, single.chan = TRUE)
}
\arguments{
\item{dem}{raster  Elevation raster (DEM) using a projected coordinate system (e.g UTM) and regular grid spacing. Not required if atb raster supplied.}

\item{drn}{SpatialLines Detailed river network (DRN) in vector (ESRI Shapefile) format. Not required if atb raster supplied.}

\item{chan.width}{numeric Vector of channel widths, in m, for each reach defined in the DRN. Will be recycled if shorter than the number of channels}

\item{atb}{raster  Optional raster used as criteria for locating the channel. Typically the value of the topographic wetness index (TWI) determined from the elevations. Should be in a projected coordinate system (e.g UTM) and use a regular grid spacing.

For the TWI to be meaningful this raster should have a resolution of a least
30m. It can be calculated using the upslope.area method applied to the DEM
and atb=TRUE.}

\item{buffer}{If using a vector input then buffer the DRN by this width to capture all river cells.}

\item{atb.thresh}{If atb supplied and DRN null then this specifies the threshold value above which cells are identified as containing part of the channel network}

\item{single.chan}{If using a vector input then the first raster layer returned contains either 1 for a river cell or NA for a non-river cell. Otherwise the values are the line ids of the channel vector, that typically identify individual reaches}
}
\value{
A two-band raster with the same dimensions as the elevation or ATB raster whose first layer comprises non-zero cells where identified with the channel and whose second layer holds the proportions of those cells occupied by the channel.
}
\description{
The discretise methods both requires a raster defining the
  locations of the channel cells and the proportion of each river cell
  occupied by the channel. A detailed river network (DRN) may be available in
  vector format and can be used to compute this. If not, the channel location
  can be inferred from a spatially-distributed metric, typically the
  topographic wetness index.
}
\examples{
\dontrun{

require(dynatopmodel)
data("brompton")

chan.rast <- build_chans(dem=brompton$dem, drn=brompton$drn, buff=5, chan.width=2)
# show it
sp::plot(chan.rast[[1]], col="green", legend=FALSE)
}
}
\references{
Kirkby, M. (1975). Hydrograph modelling strategies. In Peel, R., Chisholm, Michael, Haggett, Peter, & University of Bristol. Department of Geography. (Eds.). Processes in physical and human geography : Bristol essays. pp. 69-90. London: Heinemann Educational.
}
