% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/9_dynwrap.R
\name{wrap_dataset}
\alias{wrap_dataset}
\title{Wrap a simulation into a dynwrap object}
\usage{
wrap_dataset(
  model,
  store_cellwise_grn = !is.null(model$experiment$cellwise_grn),
  store_dimred = !is.null(model$experiment$dimred),
  store_rna_velocity = !is.null(model$experiment$rna_velocity)
)
}
\arguments{
\item{model}{A dyngen output model for which the experiment has been emulated with \code{\link[=generate_experiment]{generate_experiment()}}.}

\item{store_cellwise_grn}{Whether or not to also store cellwise GRN information.}

\item{store_dimred}{Whether or not to store the dimensionality reduction constructed on the true counts.}

\item{store_rna_velocity}{WHether or not to store the log propensity ratios.}
}
\value{
A dynwrap object.
}
\description{
The output of this object can be used with \pkg{dyno}.
}
\examples{
data("example_model")
dataset <- wrap_dataset(example_model)

# dynplot::plot_dimred(dataset)
}
