
# dyngen <img src="man/figures/logo.png" align="right" />

<!-- badges: start -->

[![CRAN
Status](https://www.r-pkg.org/badges/version/dyngen)](https://cran.r-project.org/package=dyngen)
[![CRAN
Downloads](https://cranlogs.r-pkg.org/badges/dyngen)](https://cran.r-project.org/package=dyngen)
[![DOI](https://img.shields.io/badge/doi-10.1038/s41467-021-24152-2-green)](https://doi.org/10.1038/s41467-021-24152-2)
[![R-CMD-check](https://github.com/dynverse/dyngen/workflows/R-CMD-check/badge.svg)](https://github.com/dynverse/dyngen/actions?query=workflow%3AR-CMD-check)
[![Coverage
Status](https://codecov.io/gh/dynverse/dyngen/branch/master/graph/badge.svg)](https://codecov.io/gh/dynverse/dyngen?branch=master)
<!-- badges: end -->

dyngen is a novel, multi-modal simulation engine for studying dynamic
cellular processes at single-cell resolution. dyngen is more flexible
than current single-cell simulation engines, and allows better method
development and benchmarking, thereby stimulating development and
testing of novel computational methods.

dyngen is now published (CC-BY,
[doi:10.1038/s41467-021-24152-2](https://doi.org/10.1038/s41467-021-24152-2)).
Run `citation("dyngen")` to obtain the corresponding citation
information. All source code for reproducing the results in this
manuscript are available on
[GitHub](https://github.com/dynverse/dyngen_manuscript).

<img src="man/figures/overview.png" width="60%" />

## Installation

dyngen should work straight out of the CRAN box by running
`install.packages("dyngen")`. Having said that, you should definitely
configure a few system variables for optimal speed. Check the
[installation
guide](https://dyngen.dynverse.org/articles/installation.html) for more
information!

## Getting started

Check out [this
guide](https://dyngen.dynverse.org/articles/getting_started.html) on how
to get started with dyngen. You can find more guides by clicking any of
the links below:

-   [Advanced: Comparison to reference
    dataset](https://dyngen.dynverse.org/articles/advanced_topics/comparison_reference.html)
-   [Advanced: Constructing a custom
    backbone](https://dyngen.dynverse.org/articles/advanced_topics/constructing_backbone.html)
-   [Advanced: Running dyngen from a docker
    container](https://dyngen.dynverse.org/articles/advanced_topics/run_dyngen_from_docker.html)
-   [Advanced: On scalability and
    runtime](https://dyngen.dynverse.org/articles/advanced_topics/scalability_and_runtime.html)
-   [Advanced: Simulating batch
    effects](https://dyngen.dynverse.org/articles/advanced_topics/simulating_batch_effects.html)
-   [Advanced: Simulating a knockout
    experiment](https://dyngen.dynverse.org/articles/advanced_topics/simulating_knockouts.html)
-   [Advanced: Tweaking
    parameters](https://dyngen.dynverse.org/articles/advanced_topics/tweaking_parameters.html)
-   [Getting
    started](https://dyngen.dynverse.org/articles/getting_started.html)
-   [Installation
    instructions](https://dyngen.dynverse.org/articles/installation.html)
-   [Showcase different
    backbones](https://dyngen.dynverse.org/articles/showcase_backbones.html)

## Latest changes

A full list of changes is available on our
[changelog](https://dyngen.dynverse.org/news/index.html).
