% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynrData.R
\name{dynr.data}
\alias{dynr.data}
\title{Create a list of data for parameter estimation (cooking dynr) using \code{\link{dynr.cook}}}
\usage{
dynr.data(dataframe, id, time, observed, covariates)
}
\arguments{
\item{dataframe}{the data in the format of a data frame in R that contain a column of subject ID numbers 
(i.e., an ID variable), a column indicating subject-specific measurement occasions
(i.e., a TIME variable), at least one column of observed values, and any number of covariates. 
If the data are fit to a discrete-time model, the TIME variable should contain subject-specific sequences 
of consecutively equally spaced numbers (e.g, 1, 2, 3, ...).
If the data are fit to a continuous-time model, the TIME varibles can contain subject-specific increasing sequences 
of irregularly spaced real numbers.  
Missing values in the observed variables shoud be indicated by NA. Missing values in covariates are not allowed. 
That is, missing values in the covariates, if there are any, should be imputed first.}

\item{id}{a character string of the name of the ID variable in the data.}

\item{time}{a character string of the name of the TIME variable in the data.}

\item{observed}{a vector of character strings of the names of the observed variables in the data.}

\item{covariates}{a vector of character strings of the names of the covariates in the data, which can be missing.}
}
\description{
Create a list of data for parameter estimation (cooking dynr) using \code{\link{dynr.cook}}
}
\examples{
data(EMGsim)
dd <- dynr.data(EMGsim, id='id', time='time', observed='EMG', covariates='self')
}

