% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap_label_milestones.R
\name{label_milestones}
\alias{label_milestones}
\alias{label_milestones_markers}
\alias{is_wrapper_with_milestone_labelling}
\alias{get_milestone_labelling}
\title{Label milestones either manually (\code{label_milestones}) or using marker genes (\code{label_milestones_markers})}
\usage{
label_milestones(trajectory, labelling)

label_milestones_markers(trajectory, markers,
  expression_source = "expression", n_nearest_cells = 20)

is_wrapper_with_milestone_labelling(trajectory)

get_milestone_labelling(trajectory, label_milestones = NULL)
}
\arguments{
\item{trajectory}{The trajectory as created by \code{\link[=infer_trajectory]{infer_trajectory()}} or \code{\link[=add_trajectory]{add_trajectory()}}}

\item{labelling}{Named character vector containing for a milestone a new label}

\item{markers}{List containing for each label a list of marker genes}

\item{expression_source}{The expression source}

\item{n_nearest_cells}{The number of nearest cells to use for extracting milestone expression}

\item{label_milestones}{How to label the milestones. Can be TRUE (in which case the labels within the trajectory will be used), "all" (in which case both given labels and milestone_ids will be used), a named character vector, or FALSE}
}
\value{
\strong{\code{label_milestones}}:  A trajectory object with \emph{milestone_labelling}, a named vector where milestone identifiers are mapped to their labels

\strong{\code{get_milestone_labelling}}: A named vector giving a mapping between milestones and their labels. If certain milestones were not given a label, this vector will give the identifiers themselves.
}
\description{
\code{label_milestones} can be used to manually assign labels to a milestone using their identifiers
}
\details{
\code{label_milestones_markers} will assign a label to a milestone if its marker profile most closely resembles a given profile
}
\examples{
trajectory <- example_trajectory

# manual labelling
trajectory <- label_milestones(
  trajectory,
  labelling = c("milestone_begin" = "Let's go")
)
get_milestone_labelling(trajectory)

# marker gene labelling
trajectory <- label_milestones_markers(
  trajectory,
  markers = list(A_high = "A")
)
get_milestone_labelling(trajectory)

is_wrapper_with_milestone_labelling(trajectory)

}
\keyword{adapt_trajectory}
