% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC_info_theory.R
\name{zero_entropy_variables}
\alias{zero_entropy_variables}
\title{Identify variables with zero entropy}
\usage{
zero_entropy_variables(data, unit = "bits")
}
\arguments{
\item{data}{Data Frame to compute on}

\item{unit}{Unit to measure entropy. Either "bits" (default) or "nats".}
}
\value{
Character vector of variable names with zero entropy
}
\description{
Calculates Shannon entropy of variables in a data frame in bits (default) or
natural units. Missing values are omitted from the calculation.
Names of variables with zero entropy are returned.
}
\examples{
data(example_data)
zero_entropy_variables(example_data)
}
\references{
Shannon, C. E. A mathematical theory of communication. The Bell
  System Technical Journal 27, 379–423 (1948).
}
