% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funprog.R
\name{funprog}
\alias{funprog}
\alias{map}
\alias{mapn}
\alias{ffind}
\alias{filter}
\alias{reduce}
\alias{accumulate}
\alias{compose}
\title{Higher Order Functions}
\usage{
map(
  x,
  f,
  ...,
  simplify = FALSE,
  USE.NAMES = FALSE,
  FUN.VALUE = NULL,
  clust = NULL
)

mapn(
  f,
  ...,
  simplify = FALSE,
  USE.NAMES = FALSE,
  FUN.VALUE = NULL,
  clust = NULL
)

ffind(x, f, ...)

filter(x, f, ...)

reduce(x, f, init = NULL, right = FALSE)

accumulate(x, f, init, right = FALSE)

compose(...)
}
\arguments{
\item{x}{vector}

\item{f}{function to be applied to \code{x}}

\item{...}{additional arguments supplied to \code{f}, or a list of functions for \code{compose} (applied in the order provided)}

\item{simplify}{logical; should the results be simplified to an array?}

\item{USE.NAMES}{logical; should \code{x} be used as names for the result?}

\item{FUN.VALUE}{template vector for the return type}

\item{clust}{cluster to use for \code{\link[parallel:clusterApply]{parallel}} computations. See \code{\link{comprehension}} for more details. \code{FUN.VALUE} is ignored if a cluster is supplied.}

\item{init}{object used to initialize \code{reduce}, if an object other then the first value is desired}

\item{right}{logical; should the reduction start from left (default) or right?}
}
\value{
determined by the return value of the function \code{f}.
}
\description{
Common functions used in functional programming. These are similar to their
respective counterparts in Base R: \code{\link[base]{Map}}, \code{\link[base]{Reduce}},
\code{\link[base]{Filter}}, etc. However, they take any value that can be converted
to a function via \code{\link{lambda}} and the function comes after the argument
in the argument list for convenience while piping.
}
\details{
\code{map} is slightly different from \code{\link[base]{Map}} in Base R other than
the argument order. First, \code{\link{iter}} is applied to the vector \code{x}
so that users can define behavior for custom classes. Second, \code{\link{lambda}}
is applied to \code{f}. \code{map} only works for a single vector. Use \code{mapn}
to use multiple vectors as the function argument. The \code{map} functions are
wrappers around \code{\link[base]{sapply}} or \code{link[base]{vapply}} (if \code{FUN.VALUE} is provided).

The other functions behave similar to what one would expect, with the exception
of \code{accumulate}. \code{accumulate} does not produce all intermediate results;
it only provides the final cumulative vector.

\code{compose} takes multiple functions and produces a single "composed" function.
When the composed function is called, each function in the list is applied sequentially
to the arguments. The functions can be retrieved from the composed function's
attributes.
}
\section{Functions}{
\itemize{
\item \code{map}: Apply function \code{f} using elements in vector \code{x} at each index.

\item \code{mapn}: Apply function \code{f} using the element in all elements in vectors \code{...} at each index as arguments.

\item \code{ffind}: Find the position of elements in vector \code{x} that satisfy predicate function \code{f}.

\item \code{filter}: Extract elements in vector \code{x} that satisfy predicate function \code{f}.

\item \code{reduce}: Combine elements in a vector \code{x} using binary function \code{f}.

\item \code{accumulate}: Combine elements in a vector \code{x} using binary function \code{f}, accumulating the results.

\item \code{compose}: Combine functions into a single function.
}}

\examples{
x <- list(1:3, 4:6, 7:9)
map(x, ~Reduce(`-`, .i))
map(x, sqrt)

filter(x[[1]], ~.i < 3)

reduce(x[[3]], `*`, init=1)

f <- compose(sqrt, log, `*`(2))
f(10)
}
