% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epsilon.R
\name{epsilon_additive}
\alias{epsilon_additive}
\alias{epsilon_mult}
\title{Epsilon metric}
\usage{
epsilon_additive(data, reference, maximise = FALSE)

epsilon_mult(data, reference, maximise = FALSE)
}
\arguments{
\item{data}{(\code{matrix} | \code{data.frame}) \cr Matrix or data frame of numerical
values, where each row gives the coordinates of a point.}

\item{reference}{(\code{matrix} | \code{data.frame}) \cr Reference set as a matrix or
data.frame of numerical values.}

\item{maximise}{(\code{logical()} | \code{logical(1)}) \cr Whether the objectives must be
maximised instead of minimised. Either a single logical value that applies
to all objectives or a vector of logical values, with one value per
objective.}
}
\value{
A single numerical value.
}
\description{
Computes the epsilon metric, either additive or multiplicative.
}
\details{
Given objective vectors \eqn{a} and \eqn{b}, \eqn{epsilon(a,b)} is computed
in the case of minimization as \eqn{a/b} for the multiplicative variant
(respectively, \eqn{a - b} for the additive variant), whereas in the case of
maximization it is computed as \eqn{b/a} for the multiplicative variant
(respectively, \eqn{b - a} for the additive variant). This allows computing
a single value for problems where some objectives are to be maximized while
others are to be minimized. Moreover, a lower value corresponds to a better
approximation set, independently of the type of problem (minimization,
maximization or mixed). However, the meaning of the value is different for
each objective type. For example, imagine that \eqn{f1} is to be minimized
and \eqn{f2} is to be maximized, and the multiplicative epsilon computed
here for \eqn{epsilon(A,B) = 3}. This means that \eqn{A} needs to be
multiplied by 1/3 for all \eqn{f1} values and by 3 for all \eqn{f2} values
in order to weakly dominate \eqn{B}. This also means that the computation of
the multiplicative version for negative values doesn't make sense.
}
\examples{
extdata_path <- system.file(package="eaf","extdata")
path.A1 <- file.path(extdata_path, "ALG_1_dat.xz")
path.A2 <- file.path(extdata_path, "ALG_2_dat.xz")
A1 <- read_datasets(path.A1)[,1:2]
A2 <- read_datasets(path.A2)[,1:2]
ref <- filter_dominated(rbind(A1, A2))
epsilon_additive(A1, ref)
epsilon_additive(A2, ref)

# Multiplicative version of epsilon metric
ref <- filter_dominated(rbind(A1, A2))
epsilon_mult(A1, ref)
epsilon_mult(A2, ref)

}
\references{
\insertRef{ZitThiLauFon2003:tec}{eaf}
}
\author{
Manuel \enc{López-Ibáñez}{Lopez-Ibanez}
}
