% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igd.R
\name{igd}
\alias{igd}
\alias{IGDX}
\alias{igd_plus}
\alias{avg_hausdorff_dist}
\title{Inverted Generational Distance (IGD and IGD+) and Averaged Hausdorff Distance}
\usage{
igd(data, reference, maximise = FALSE)

igd_plus(data, reference, maximise = FALSE)

avg_hausdorff_dist(data, reference, maximise = FALSE, p = 1L)
}
\arguments{
\item{data}{(\code{matrix} | \code{data.frame}) \cr Matrix or data frame of numerical
values, where each row gives the coordinates of a point.}

\item{reference}{(\code{matrix} | \code{data.frame}) \cr Reference set as a matrix or
data.frame of numerical values.}

\item{maximise}{(\code{logical()} | \code{logical(1)}) \cr Whether the objectives must be
maximised instead of minimised. Either a single logical value that applies
to all objectives or a vector of logical values, with one value per
objective.}

\item{p}{(\code{integer(1)}) Hausdorff distance parameter (default: \code{1L}).}
}
\value{
(\code{numeric(1)}) A single numerical value.
}
\description{
Functions to compute the inverted generational distance (IGD and IGD+) and
the averaged Hausdorff distance between nondominated sets of points.
}
\details{
The generational distance (GD) of a set \eqn{A} is defined as the distance
between each point \eqn{a \in A} and the closest point \eqn{r} in a
reference set \eqn{R}, averaged over the size of \eqn{A}. Formally,

\deqn{GD(A,R) = \frac{1}{|A|}\left(\sum_{a\in A}\min_{r\in R} d(a,r)^p\right)^{\frac{1}{p}} }{GD(A,R) = (1/|A|) * ( sum_{a in A} min_{r in R} d(a,r)^p )^(1/p)}
where:
\deqn{d(a,r) = \sqrt{\sum_{k=1}^M (a_k - r_k)^2} }{d(a,r) = sqrt( sum_{k=1}^M (a_k - r_k)^2)}

The inverted generational distance (IGD) is calculated as \eqn{IGD(A,R) = GD(R,A)}
with \eqn{p=1}.

GD was first proposed by \citet{VelLam1998gp} with \eqn{p=2}. IGD seems to
have been mentioned first by \citet{CoeSie2004igd}, however, some people
also used the name D-metric for the same concept with \eqn{p=1} and later
papers have often used IGD/GD with \eqn{p=1}.

IGDX is the application of IGD to decision vectors instead of objective
vectors to measure closeness and diversity in decision
space \citep{ZhoZhaJin2009igdx}. One can use the functions here directly,
just passing the decision vectors as \code{data}.

The modified inverted generational distanced (IGD+) was proposed by
\citet{IshMasTanNoj2015igd} to ensure that IGD+ is weakly Pareto compliant,
similarly to unary epsilon. It averages over \eqn{|R|} within the exponent
\eqn{1/p} and modifies the distance measure as:

\deqn{d^+(r,a) = \sqrt{\sum_{k=1}^M (\max\{r_k - a_k, 0\})^2}}{d^+(r,a) = sqrt(sum_{k=1}^M (max {r_k - a_k, 0 })^2)}

The average Hausdorff distance (\eqn{\Delta_p}) was proposed by \citet{SchEsqLarCoe2012tec} and
it is calculated as:

\deqn{\Delta_p(A,R) = \max\{ IGD_p(A,R), IGD_p(R,A) \}}

See \citet{BezLopStu2017emo} for a comparison.
}
\examples{
extdata_path <- system.file(package="eaf","extdata")
path.A1 <- file.path(extdata_path, "ALG_1_dat.xz")
path.A2 <- file.path(extdata_path, "ALG_2_dat.xz")
A1 <- read_datasets(path.A1)[,1:2]
A2 <- read_datasets(path.A2)[,1:2]
ref <- filter_dominated(rbind(A1, A2))
igd(A1, ref)
igd(A2, ref)

# IGD+ (Pareto compliant)
igd_plus(A1, ref)
igd_plus(A2, ref)

# Average Haussdorff distance
avg_hausdorff_dist(A1, ref)
avg_hausdorff_dist(A2, ref)
}
\references{
\insertAllCited{}
}
\author{
Manuel \enc{López-Ibáñez}{Lopez-Ibanez}
}
