% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.earlyR.R
\name{plot.earlyR}
\alias{plot.earlyR}
\alias{points.earlyR}
\title{Plot earlyR objects}
\usage{
\method{plot}{earlyR}(x, type = c("R", "lambdas"), scale = 1, ...)

\method{points}{earlyR}(x, scale = 1, ...)
}
\arguments{
\item{x}{A \code{earlyR} object.}

\item{type}{The type of graphic to be generated, matching either "R" or
"lamdbas"; "R" will plot the likelihood of R values; "lambdas" will plot
the force of infection over time.}

\item{scale}{A numeric value indicating the scaling factor for lambdas on the
'y' axis.}

\item{...}{Further arguments to be passed to other methods (not used).

if (require(incidence)) {

## example: onsets on days 1, 5, 6 and 12; estimation on day 24
onset <- c(1, 5, 6, 12)
x <- incidence(onset, last_date = 24)
x

res <- get_R(x, disease = "ebola")
res
plot(res)
plot(res, "lambdas")
plot(res, "lambdas", scaling = 5)
points(onset, 1:4, cex = 3, pch = 20)

}}
}
\description{
These functions are designed for plotting \code{earlyR} objects, output by
the function \code{\link{get_R}}. It can plot either the likelihood of R
values, or the force of infection over time (see argument \code{type}). For
\code{points}, the latter is used.
}
\author{
Thibaut Jombart \email{thibautjombart@gmail.com}
}
