// Generated by using Rcpp::compileAttributes() -> do not edit by hand
// Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#include <RcppThread.h>
#include <RcppEigen.h>
#include <Rcpp.h>

using namespace Rcpp;

#ifdef RCPP_USE_GLOBAL_ROSTREAM
Rcpp::Rostream<true>&  Rcpp::Rcout = Rcpp::Rcpp_cout_get();
Rcpp::Rostream<false>& Rcpp::Rcerr = Rcpp::Rcpp_cerr_get();
#endif

// time_mat
Eigen::MatrixXd time_mat(const Eigen::ArrayXd& time);
RcppExport SEXP _earthtide_time_mat(SEXP timeSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Eigen::ArrayXd& >::type time(timeSEXP);
    rcpp_result_gen = Rcpp::wrap(time_mat(time));
    return rcpp_result_gen;
END_RCPP
}
// time_der_mat
Eigen::MatrixXd time_der_mat(const Eigen::ArrayXd& time);
RcppExport SEXP _earthtide_time_der_mat(SEXP timeSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Eigen::ArrayXd& >::type time(timeSEXP);
    rcpp_result_gen = Rcpp::wrap(time_der_mat(time));
    return rcpp_result_gen;
END_RCPP
}
// astro
Eigen::MatrixXd astro(const Eigen::ArrayXd& t_astro, const Eigen::MatrixXd simon, const double longitude, Eigen::RowVectorXd hours, Eigen::RowVectorXd ddt);
RcppExport SEXP _earthtide_astro(SEXP t_astroSEXP, SEXP simonSEXP, SEXP longitudeSEXP, SEXP hoursSEXP, SEXP ddtSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Eigen::ArrayXd& >::type t_astro(t_astroSEXP);
    Rcpp::traits::input_parameter< const Eigen::MatrixXd >::type simon(simonSEXP);
    Rcpp::traits::input_parameter< const double >::type longitude(longitudeSEXP);
    Rcpp::traits::input_parameter< Eigen::RowVectorXd >::type hours(hoursSEXP);
    Rcpp::traits::input_parameter< Eigen::RowVectorXd >::type ddt(ddtSEXP);
    rcpp_result_gen = Rcpp::wrap(astro(t_astro, simon, longitude, hours, ddt));
    return rcpp_result_gen;
END_RCPP
}
// astro_der
Eigen::MatrixXd astro_der(const Eigen::ArrayXd& t_astro, const Eigen::MatrixXd simon);
RcppExport SEXP _earthtide_astro_der(SEXP t_astroSEXP, SEXP simonSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Eigen::ArrayXd& >::type t_astro(t_astroSEXP);
    Rcpp::traits::input_parameter< const Eigen::MatrixXd >::type simon(simonSEXP);
    rcpp_result_gen = Rcpp::wrap(astro_der(t_astro, simon));
    return rcpp_result_gen;
END_RCPP
}
// factorial
double factorial(size_t x);
RcppExport SEXP _earthtide_factorial(SEXP xSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< size_t >::type x(xSEXP);
    rcpp_result_gen = Rcpp::wrap(factorial(x));
    return rcpp_result_gen;
END_RCPP
}
// log_factorial
double log_factorial(size_t x);
RcppExport SEXP _earthtide_log_factorial(SEXP xSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< size_t >::type x(xSEXP);
    rcpp_result_gen = Rcpp::wrap(log_factorial(x));
    return rcpp_result_gen;
END_RCPP
}
// scale_legendre
double scale_legendre(int l, int m);
RcppExport SEXP _earthtide_scale_legendre(SEXP lSEXP, SEXP mSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< int >::type l(lSEXP);
    Rcpp::traits::input_parameter< int >::type m(mSEXP);
    rcpp_result_gen = Rcpp::wrap(scale_legendre(l, m));
    return rcpp_result_gen;
END_RCPP
}
// legendre_cpp
double legendre_cpp(int l, int m, double x);
RcppExport SEXP _earthtide_legendre_cpp(SEXP lSEXP, SEXP mSEXP, SEXP xSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< int >::type l(lSEXP);
    Rcpp::traits::input_parameter< int >::type m(mSEXP);
    Rcpp::traits::input_parameter< double >::type x(xSEXP);
    rcpp_result_gen = Rcpp::wrap(legendre_cpp(l, m, x));
    return rcpp_result_gen;
END_RCPP
}
// legendre_deriv_cpp
double legendre_deriv_cpp(int l, int m, double x);
RcppExport SEXP _earthtide_legendre_deriv_cpp(SEXP lSEXP, SEXP mSEXP, SEXP xSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< int >::type l(lSEXP);
    Rcpp::traits::input_parameter< int >::type m(mSEXP);
    Rcpp::traits::input_parameter< double >::type x(xSEXP);
    rcpp_result_gen = Rcpp::wrap(legendre_deriv_cpp(l, m, x));
    return rcpp_result_gen;
END_RCPP
}
// legendre
Eigen::MatrixXd legendre(size_t l_max, double x);
RcppExport SEXP _earthtide_legendre(SEXP l_maxSEXP, SEXP xSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< size_t >::type l_max(l_maxSEXP);
    Rcpp::traits::input_parameter< double >::type x(xSEXP);
    rcpp_result_gen = Rcpp::wrap(legendre(l_max, x));
    return rcpp_result_gen;
END_RCPP
}
// get_catalog_indices
Eigen::MatrixXi get_catalog_indices(const Eigen::VectorXi& index, const size_t ng);
RcppExport SEXP _earthtide_get_catalog_indices(SEXP indexSEXP, SEXP ngSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Eigen::VectorXi& >::type index(indexSEXP);
    Rcpp::traits::input_parameter< const size_t >::type ng(ngSEXP);
    rcpp_result_gen = Rcpp::wrap(get_catalog_indices(index, ng));
    return rcpp_result_gen;
END_RCPP
}
// subset_2_eigen
Eigen::VectorXi subset_2_eigen(const Eigen::VectorXi& input);
RcppExport SEXP _earthtide_subset_2_eigen(SEXP inputSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Eigen::VectorXi& >::type input(inputSEXP);
    rcpp_result_gen = Rcpp::wrap(subset_2_eigen(input));
    return rcpp_result_gen;
END_RCPP
}
// subset_eigen
Eigen::ArrayXd subset_eigen(const Eigen::ArrayXd& input, const Eigen::VectorXi& subs);
RcppExport SEXP _earthtide_subset_eigen(SEXP inputSEXP, SEXP subsSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Eigen::ArrayXd& >::type input(inputSEXP);
    Rcpp::traits::input_parameter< const Eigen::VectorXi& >::type subs(subsSEXP);
    rcpp_result_gen = Rcpp::wrap(subset_eigen(input, subs));
    return rcpp_result_gen;
END_RCPP
}
// unique_eigen
Eigen::VectorXi unique_eigen(Eigen::VectorXi index);
RcppExport SEXP _earthtide_unique_eigen(SEXP indexSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Eigen::VectorXi >::type index(indexSEXP);
    rcpp_result_gen = Rcpp::wrap(unique_eigen(index));
    return rcpp_result_gen;
END_RCPP
}
// calc_dc2
Eigen::ArrayXd calc_dc2(const Eigen::MatrixXd& k_mat, const Eigen::VectorXd& astro, const Eigen::ArrayXd& pk, const double to_rad);
RcppExport SEXP _earthtide_calc_dc2(SEXP k_matSEXP, SEXP astroSEXP, SEXP pkSEXP, SEXP to_radSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type k_mat(k_matSEXP);
    Rcpp::traits::input_parameter< const Eigen::VectorXd& >::type astro(astroSEXP);
    Rcpp::traits::input_parameter< const Eigen::ArrayXd& >::type pk(pkSEXP);
    Rcpp::traits::input_parameter< const double >::type to_rad(to_radSEXP);
    rcpp_result_gen = Rcpp::wrap(calc_dc2(k_mat, astro, pk, to_rad));
    return rcpp_result_gen;
END_RCPP
}
// calc_dc3
Eigen::ArrayXd calc_dc3(const Eigen::MatrixXd& k_mat, const Eigen::VectorXd& astro_der);
RcppExport SEXP _earthtide_calc_dc3(SEXP k_matSEXP, SEXP astro_derSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type k_mat(k_matSEXP);
    Rcpp::traits::input_parameter< const Eigen::VectorXd& >::type astro_der(astro_derSEXP);
    rcpp_result_gen = Rcpp::wrap(calc_dc3(k_mat, astro_der));
    return rcpp_result_gen;
END_RCPP
}
// set_fac
Eigen::ArrayXd set_fac(const Eigen::ArrayXd& body, const Eigen::ArrayXi& body_inds, const Eigen::MatrixXd& k_mat, const Eigen::VectorXd& astro_der, const Eigen::ArrayXd& dc3, const double delta, const double deltar, const double o1, const double resonance, const size_t max_amp);
RcppExport SEXP _earthtide_set_fac(SEXP bodySEXP, SEXP body_indsSEXP, SEXP k_matSEXP, SEXP astro_derSEXP, SEXP dc3SEXP, SEXP deltaSEXP, SEXP deltarSEXP, SEXP o1SEXP, SEXP resonanceSEXP, SEXP max_ampSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Eigen::ArrayXd& >::type body(bodySEXP);
    Rcpp::traits::input_parameter< const Eigen::ArrayXi& >::type body_inds(body_indsSEXP);
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type k_mat(k_matSEXP);
    Rcpp::traits::input_parameter< const Eigen::VectorXd& >::type astro_der(astro_derSEXP);
    Rcpp::traits::input_parameter< const Eigen::ArrayXd& >::type dc3(dc3SEXP);
    Rcpp::traits::input_parameter< const double >::type delta(deltaSEXP);
    Rcpp::traits::input_parameter< const double >::type deltar(deltarSEXP);
    Rcpp::traits::input_parameter< const double >::type o1(o1SEXP);
    Rcpp::traits::input_parameter< const double >::type resonance(resonanceSEXP);
    Rcpp::traits::input_parameter< const size_t >::type max_amp(max_ampSEXP);
    rcpp_result_gen = Rcpp::wrap(set_fac(body, body_inds, k_mat, astro_der, dc3, delta, deltar, o1, resonance, max_amp));
    return rcpp_result_gen;
END_RCPP
}
// et_analyze_one
Eigen::MatrixXd et_analyze_one(const Eigen::VectorXd& astro, const Eigen::VectorXd& astro_der, const Eigen::MatrixXd& k_mat, const Eigen::ArrayXd& pk, const Eigen::ArrayXd& body, const Eigen::ArrayXi& body_inds, const double delta, const double deltar, const Eigen::MatrixXd& x, const Eigen::MatrixXd& y, const double j2000, const double o1, const double resonance, const size_t max_amp, bool scale);
RcppExport SEXP _earthtide_et_analyze_one(SEXP astroSEXP, SEXP astro_derSEXP, SEXP k_matSEXP, SEXP pkSEXP, SEXP bodySEXP, SEXP body_indsSEXP, SEXP deltaSEXP, SEXP deltarSEXP, SEXP xSEXP, SEXP ySEXP, SEXP j2000SEXP, SEXP o1SEXP, SEXP resonanceSEXP, SEXP max_ampSEXP, SEXP scaleSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Eigen::VectorXd& >::type astro(astroSEXP);
    Rcpp::traits::input_parameter< const Eigen::VectorXd& >::type astro_der(astro_derSEXP);
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type k_mat(k_matSEXP);
    Rcpp::traits::input_parameter< const Eigen::ArrayXd& >::type pk(pkSEXP);
    Rcpp::traits::input_parameter< const Eigen::ArrayXd& >::type body(bodySEXP);
    Rcpp::traits::input_parameter< const Eigen::ArrayXi& >::type body_inds(body_indsSEXP);
    Rcpp::traits::input_parameter< const double >::type delta(deltaSEXP);
    Rcpp::traits::input_parameter< const double >::type deltar(deltarSEXP);
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type x(xSEXP);
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type y(ySEXP);
    Rcpp::traits::input_parameter< const double >::type j2000(j2000SEXP);
    Rcpp::traits::input_parameter< const double >::type o1(o1SEXP);
    Rcpp::traits::input_parameter< const double >::type resonance(resonanceSEXP);
    Rcpp::traits::input_parameter< const size_t >::type max_amp(max_ampSEXP);
    Rcpp::traits::input_parameter< bool >::type scale(scaleSEXP);
    rcpp_result_gen = Rcpp::wrap(et_analyze_one(astro, astro_der, k_mat, pk, body, body_inds, delta, deltar, x, y, j2000, o1, resonance, max_amp, scale));
    return rcpp_result_gen;
END_RCPP
}
// et_predict_one
double et_predict_one(const Eigen::VectorXd& astro, const Eigen::VectorXd& astro_der, const Eigen::MatrixXd& k_mat, const Eigen::ArrayXd& pk, const Eigen::ArrayXd& body, const Eigen::ArrayXi& body_inds, const double delta, const double deltar, const Eigen::MatrixXd& x, const Eigen::MatrixXd& y, const double j2000, const double o1, const double resonance, const size_t max_amp);
RcppExport SEXP _earthtide_et_predict_one(SEXP astroSEXP, SEXP astro_derSEXP, SEXP k_matSEXP, SEXP pkSEXP, SEXP bodySEXP, SEXP body_indsSEXP, SEXP deltaSEXP, SEXP deltarSEXP, SEXP xSEXP, SEXP ySEXP, SEXP j2000SEXP, SEXP o1SEXP, SEXP resonanceSEXP, SEXP max_ampSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Eigen::VectorXd& >::type astro(astroSEXP);
    Rcpp::traits::input_parameter< const Eigen::VectorXd& >::type astro_der(astro_derSEXP);
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type k_mat(k_matSEXP);
    Rcpp::traits::input_parameter< const Eigen::ArrayXd& >::type pk(pkSEXP);
    Rcpp::traits::input_parameter< const Eigen::ArrayXd& >::type body(bodySEXP);
    Rcpp::traits::input_parameter< const Eigen::ArrayXi& >::type body_inds(body_indsSEXP);
    Rcpp::traits::input_parameter< const double >::type delta(deltaSEXP);
    Rcpp::traits::input_parameter< const double >::type deltar(deltarSEXP);
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type x(xSEXP);
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type y(ySEXP);
    Rcpp::traits::input_parameter< const double >::type j2000(j2000SEXP);
    Rcpp::traits::input_parameter< const double >::type o1(o1SEXP);
    Rcpp::traits::input_parameter< const double >::type resonance(resonanceSEXP);
    Rcpp::traits::input_parameter< const size_t >::type max_amp(max_ampSEXP);
    rcpp_result_gen = Rcpp::wrap(et_predict_one(astro, astro_der, k_mat, pk, body, body_inds, delta, deltar, x, y, j2000, o1, resonance, max_amp));
    return rcpp_result_gen;
END_RCPP
}
// et_calculate
Eigen::MatrixXd et_calculate(const Eigen::MatrixXd& astro, const Eigen::MatrixXd& astro_der, const Eigen::MatrixXd& k_mat, const Eigen::ArrayXd& phases, const Eigen::ArrayXd& delta, const double deltar, const Eigen::MatrixXd& cc, const Eigen::MatrixXd& ss, const Eigen::ArrayXd& dgk, const Eigen::VectorXi& jcof, const Eigen::ArrayXd& j2000, const double o1, const double resonance, const Eigen::VectorXi& index, const Eigen::ArrayXd& multiplier, bool predict, bool scale, size_t n_thread);
RcppExport SEXP _earthtide_et_calculate(SEXP astroSEXP, SEXP astro_derSEXP, SEXP k_matSEXP, SEXP phasesSEXP, SEXP deltaSEXP, SEXP deltarSEXP, SEXP ccSEXP, SEXP ssSEXP, SEXP dgkSEXP, SEXP jcofSEXP, SEXP j2000SEXP, SEXP o1SEXP, SEXP resonanceSEXP, SEXP indexSEXP, SEXP multiplierSEXP, SEXP predictSEXP, SEXP scaleSEXP, SEXP n_threadSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type astro(astroSEXP);
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type astro_der(astro_derSEXP);
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type k_mat(k_matSEXP);
    Rcpp::traits::input_parameter< const Eigen::ArrayXd& >::type phases(phasesSEXP);
    Rcpp::traits::input_parameter< const Eigen::ArrayXd& >::type delta(deltaSEXP);
    Rcpp::traits::input_parameter< const double >::type deltar(deltarSEXP);
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type cc(ccSEXP);
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type ss(ssSEXP);
    Rcpp::traits::input_parameter< const Eigen::ArrayXd& >::type dgk(dgkSEXP);
    Rcpp::traits::input_parameter< const Eigen::VectorXi& >::type jcof(jcofSEXP);
    Rcpp::traits::input_parameter< const Eigen::ArrayXd& >::type j2000(j2000SEXP);
    Rcpp::traits::input_parameter< const double >::type o1(o1SEXP);
    Rcpp::traits::input_parameter< const double >::type resonance(resonanceSEXP);
    Rcpp::traits::input_parameter< const Eigen::VectorXi& >::type index(indexSEXP);
    Rcpp::traits::input_parameter< const Eigen::ArrayXd& >::type multiplier(multiplierSEXP);
    Rcpp::traits::input_parameter< bool >::type predict(predictSEXP);
    Rcpp::traits::input_parameter< bool >::type scale(scaleSEXP);
    Rcpp::traits::input_parameter< size_t >::type n_thread(n_threadSEXP);
    rcpp_result_gen = Rcpp::wrap(et_calculate(astro, astro_der, k_mat, phases, delta, deltar, cc, ss, dgk, jcof, j2000, o1, resonance, index, multiplier, predict, scale, n_thread));
    return rcpp_result_gen;
END_RCPP
}
// et_analyze_n
Eigen::MatrixXd et_analyze_n(const Eigen::VectorXd& astro, const Eigen::VectorXd& astro_der, const Eigen::MatrixXd& k_mat, const Eigen::ArrayXd& pk, const Eigen::ArrayXd& body, const Eigen::ArrayXi& body_inds, const double delta, const double deltar, const Eigen::MatrixXd& x, const Eigen::MatrixXd& y, const Eigen::VectorXd& j2000, const double o1, const double resonance, const size_t max_amp, bool scale, const double update_coef);
RcppExport SEXP _earthtide_et_analyze_n(SEXP astroSEXP, SEXP astro_derSEXP, SEXP k_matSEXP, SEXP pkSEXP, SEXP bodySEXP, SEXP body_indsSEXP, SEXP deltaSEXP, SEXP deltarSEXP, SEXP xSEXP, SEXP ySEXP, SEXP j2000SEXP, SEXP o1SEXP, SEXP resonanceSEXP, SEXP max_ampSEXP, SEXP scaleSEXP, SEXP update_coefSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Eigen::VectorXd& >::type astro(astroSEXP);
    Rcpp::traits::input_parameter< const Eigen::VectorXd& >::type astro_der(astro_derSEXP);
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type k_mat(k_matSEXP);
    Rcpp::traits::input_parameter< const Eigen::ArrayXd& >::type pk(pkSEXP);
    Rcpp::traits::input_parameter< const Eigen::ArrayXd& >::type body(bodySEXP);
    Rcpp::traits::input_parameter< const Eigen::ArrayXi& >::type body_inds(body_indsSEXP);
    Rcpp::traits::input_parameter< const double >::type delta(deltaSEXP);
    Rcpp::traits::input_parameter< const double >::type deltar(deltarSEXP);
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type x(xSEXP);
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type y(ySEXP);
    Rcpp::traits::input_parameter< const Eigen::VectorXd& >::type j2000(j2000SEXP);
    Rcpp::traits::input_parameter< const double >::type o1(o1SEXP);
    Rcpp::traits::input_parameter< const double >::type resonance(resonanceSEXP);
    Rcpp::traits::input_parameter< const size_t >::type max_amp(max_ampSEXP);
    Rcpp::traits::input_parameter< bool >::type scale(scaleSEXP);
    Rcpp::traits::input_parameter< const double >::type update_coef(update_coefSEXP);
    rcpp_result_gen = Rcpp::wrap(et_analyze_n(astro, astro_der, k_mat, pk, body, body_inds, delta, deltar, x, y, j2000, o1, resonance, max_amp, scale, update_coef));
    return rcpp_result_gen;
END_RCPP
}
// et_predict_n
Eigen::VectorXd et_predict_n(const Eigen::VectorXd& astro, const Eigen::VectorXd& astro_der, const Eigen::MatrixXd& k_mat, const Eigen::ArrayXd& pk, const Eigen::ArrayXd& body, const Eigen::ArrayXi& body_inds, const double delta, const double deltar, const Eigen::MatrixXd& x, const Eigen::MatrixXd& y, const Eigen::VectorXd& j2000, const double o1, const double resonance, const size_t max_amp, const double update_coef);
RcppExport SEXP _earthtide_et_predict_n(SEXP astroSEXP, SEXP astro_derSEXP, SEXP k_matSEXP, SEXP pkSEXP, SEXP bodySEXP, SEXP body_indsSEXP, SEXP deltaSEXP, SEXP deltarSEXP, SEXP xSEXP, SEXP ySEXP, SEXP j2000SEXP, SEXP o1SEXP, SEXP resonanceSEXP, SEXP max_ampSEXP, SEXP update_coefSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Eigen::VectorXd& >::type astro(astroSEXP);
    Rcpp::traits::input_parameter< const Eigen::VectorXd& >::type astro_der(astro_derSEXP);
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type k_mat(k_matSEXP);
    Rcpp::traits::input_parameter< const Eigen::ArrayXd& >::type pk(pkSEXP);
    Rcpp::traits::input_parameter< const Eigen::ArrayXd& >::type body(bodySEXP);
    Rcpp::traits::input_parameter< const Eigen::ArrayXi& >::type body_inds(body_indsSEXP);
    Rcpp::traits::input_parameter< const double >::type delta(deltaSEXP);
    Rcpp::traits::input_parameter< const double >::type deltar(deltarSEXP);
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type x(xSEXP);
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type y(ySEXP);
    Rcpp::traits::input_parameter< const Eigen::VectorXd& >::type j2000(j2000SEXP);
    Rcpp::traits::input_parameter< const double >::type o1(o1SEXP);
    Rcpp::traits::input_parameter< const double >::type resonance(resonanceSEXP);
    Rcpp::traits::input_parameter< const size_t >::type max_amp(max_ampSEXP);
    Rcpp::traits::input_parameter< const double >::type update_coef(update_coefSEXP);
    rcpp_result_gen = Rcpp::wrap(et_predict_n(astro, astro_der, k_mat, pk, body, body_inds, delta, deltar, x, y, j2000, o1, resonance, max_amp, update_coef));
    return rcpp_result_gen;
END_RCPP
}
// et_calculate_n
Eigen::MatrixXd et_calculate_n(const Eigen::MatrixXd& astro, const Eigen::MatrixXd& astro_der, const Eigen::MatrixXd& k_mat, const Eigen::ArrayXd& phases, const Eigen::ArrayXd& delta, const double deltar, const Eigen::MatrixXd& cc, const Eigen::MatrixXd& ss, const Eigen::ArrayXd& dgk, const Eigen::VectorXi& jcof, const Eigen::ArrayXd& j2000, const double o1, const double resonance, const Eigen::VectorXi& index, const Eigen::ArrayXd& multiplier, const bool predict, const bool scale, const size_t n_thread, const size_t astro_update, const double update_coef);
RcppExport SEXP _earthtide_et_calculate_n(SEXP astroSEXP, SEXP astro_derSEXP, SEXP k_matSEXP, SEXP phasesSEXP, SEXP deltaSEXP, SEXP deltarSEXP, SEXP ccSEXP, SEXP ssSEXP, SEXP dgkSEXP, SEXP jcofSEXP, SEXP j2000SEXP, SEXP o1SEXP, SEXP resonanceSEXP, SEXP indexSEXP, SEXP multiplierSEXP, SEXP predictSEXP, SEXP scaleSEXP, SEXP n_threadSEXP, SEXP astro_updateSEXP, SEXP update_coefSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type astro(astroSEXP);
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type astro_der(astro_derSEXP);
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type k_mat(k_matSEXP);
    Rcpp::traits::input_parameter< const Eigen::ArrayXd& >::type phases(phasesSEXP);
    Rcpp::traits::input_parameter< const Eigen::ArrayXd& >::type delta(deltaSEXP);
    Rcpp::traits::input_parameter< const double >::type deltar(deltarSEXP);
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type cc(ccSEXP);
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type ss(ssSEXP);
    Rcpp::traits::input_parameter< const Eigen::ArrayXd& >::type dgk(dgkSEXP);
    Rcpp::traits::input_parameter< const Eigen::VectorXi& >::type jcof(jcofSEXP);
    Rcpp::traits::input_parameter< const Eigen::ArrayXd& >::type j2000(j2000SEXP);
    Rcpp::traits::input_parameter< const double >::type o1(o1SEXP);
    Rcpp::traits::input_parameter< const double >::type resonance(resonanceSEXP);
    Rcpp::traits::input_parameter< const Eigen::VectorXi& >::type index(indexSEXP);
    Rcpp::traits::input_parameter< const Eigen::ArrayXd& >::type multiplier(multiplierSEXP);
    Rcpp::traits::input_parameter< const bool >::type predict(predictSEXP);
    Rcpp::traits::input_parameter< const bool >::type scale(scaleSEXP);
    Rcpp::traits::input_parameter< const size_t >::type n_thread(n_threadSEXP);
    Rcpp::traits::input_parameter< const size_t >::type astro_update(astro_updateSEXP);
    Rcpp::traits::input_parameter< const double >::type update_coef(update_coefSEXP);
    rcpp_result_gen = Rcpp::wrap(et_calculate_n(astro, astro_der, k_mat, phases, delta, deltar, cc, ss, dgk, jcof, j2000, o1, resonance, index, multiplier, predict, scale, n_thread, astro_update, update_coef));
    return rcpp_result_gen;
END_RCPP
}

static const R_CallMethodDef CallEntries[] = {
    {"_earthtide_time_mat", (DL_FUNC) &_earthtide_time_mat, 1},
    {"_earthtide_time_der_mat", (DL_FUNC) &_earthtide_time_der_mat, 1},
    {"_earthtide_astro", (DL_FUNC) &_earthtide_astro, 5},
    {"_earthtide_astro_der", (DL_FUNC) &_earthtide_astro_der, 2},
    {"_earthtide_factorial", (DL_FUNC) &_earthtide_factorial, 1},
    {"_earthtide_log_factorial", (DL_FUNC) &_earthtide_log_factorial, 1},
    {"_earthtide_scale_legendre", (DL_FUNC) &_earthtide_scale_legendre, 2},
    {"_earthtide_legendre_cpp", (DL_FUNC) &_earthtide_legendre_cpp, 3},
    {"_earthtide_legendre_deriv_cpp", (DL_FUNC) &_earthtide_legendre_deriv_cpp, 3},
    {"_earthtide_legendre", (DL_FUNC) &_earthtide_legendre, 2},
    {"_earthtide_get_catalog_indices", (DL_FUNC) &_earthtide_get_catalog_indices, 2},
    {"_earthtide_subset_2_eigen", (DL_FUNC) &_earthtide_subset_2_eigen, 1},
    {"_earthtide_subset_eigen", (DL_FUNC) &_earthtide_subset_eigen, 2},
    {"_earthtide_unique_eigen", (DL_FUNC) &_earthtide_unique_eigen, 1},
    {"_earthtide_calc_dc2", (DL_FUNC) &_earthtide_calc_dc2, 4},
    {"_earthtide_calc_dc3", (DL_FUNC) &_earthtide_calc_dc3, 2},
    {"_earthtide_set_fac", (DL_FUNC) &_earthtide_set_fac, 10},
    {"_earthtide_et_analyze_one", (DL_FUNC) &_earthtide_et_analyze_one, 15},
    {"_earthtide_et_predict_one", (DL_FUNC) &_earthtide_et_predict_one, 14},
    {"_earthtide_et_calculate", (DL_FUNC) &_earthtide_et_calculate, 18},
    {"_earthtide_et_analyze_n", (DL_FUNC) &_earthtide_et_analyze_n, 16},
    {"_earthtide_et_predict_n", (DL_FUNC) &_earthtide_et_predict_n, 15},
    {"_earthtide_et_calculate_n", (DL_FUNC) &_earthtide_et_calculate_n, 20},
    {NULL, NULL, 0}
};

RcppExport void R_init_earthtide(DllInfo *dll) {
    R_registerRoutines(dll, NULL, CallEntries, NULL, NULL);
    R_useDynamicSymbols(dll, FALSE);
}
