% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4rename_ind_vars.R
\name{rename_ind_vars}
\alias{rename_ind_vars}
\title{Renames longitudinal Cross-year Individual variables and saves in long format}
\usage{
rename_ind_vars(in_direc, out_direc, only_long_vars = F, cust_vars = NULL)
}
\arguments{
\item{in_direc}{Directory of PSID Cross-year Individual file .rds file}

\item{out_direc}{Directory for renamed and transformed PSID Cross-year Individual file to be saved to}

\item{only_long_vars}{Keep only longitudinal variables in dataset}

\item{cust_vars}{Custom variables to keep in dataset (as character vector). Output will always include "ER30001", "fam_id_68", and "Year"}
}
\description{
Renames all repeated variables in the Cross-year Individual file so that matching variables across waves have the same name, and transforms the resulting dataset into long format. The longitudinal file does not include rows for respondents who were missing in a given wave, and cross-sectional variables are marked as NA during waves when they were not asked. In addition, the resulting file adds two variables for ease of use: "Year" and "fam_id_68". 

This function may require up to 8gb of RAM, and will likely throw "cannot allocate memory" errors to users with less RAM on their computer. Users with memory issues should implement the "only_long_vars" or "cust_vars" options.
}
\examples{
rename_ind_vars(
   only_long_vars=TRUE, 
   in_direc=system.file("extdata","rds_dir", package = "easyPSID"),
   out_direc=tempdir()
)
}
\keyword{PSID}
