% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_server.R
\name{check_server}
\alias{check_server}
\title{Check climate data server}
\usage{
check_server(climatic_var = NULL, year = NULL, verbose = TRUE)
}
\arguments{
\item{climatic_var}{Optional. One of "Prcp", "Tmin", or "Tmax".}

\item{year}{Optional. Year between 1950 and 2022.}

\item{verbose}{Logical. Print diagnostic messages, or just return TRUE/FALSE?}
}
\value{
TRUE if the server seems available, FALSE otherwise.
}
\description{
Check that the online climate data server is available and working correctly.
}
\details{
This function checks access to the latest version of the climatic
dataset (version 4).
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
check_server()
\dontshow{\}) # examplesIf}
}
