% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddiff.R
\name{ddiff}
\alias{ddiff}
\title{Date difference (or difference in days).}
\usage{
ddiff(x, y, unit = "day", do.date.convert = TRUE, do.numeric = TRUE)
}
\arguments{
\item{x}{Vector of starting dates or items that can be converted to dates by todate.}

\item{y}{Vector of ending dates or items that can be converted to dates by todate.}

\item{unit}{Character indicating what to use as the unit of difference. Values like d, y, m or day, year, month will work. Takes just the first letter in lower-case to determine unit.}

\item{do.date.convert}{Convert to dates before running the difference. If you know your columns are already dates, setting to FALSE will make your code run faster.}

\item{do.numeric}{Convert the output to a number instead of a date difference object.}
}
\value{
Vector of differences.
}
\description{
Date difference (or difference in days).
}
\examples{
ddiff( lubridate::mdy( '1/1/2018' ), lubridate::mdy( '3/4/2018' ) )
}
