% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcwarn.R
\name{tcwarn}
\alias{tcwarn}
\title{tryCatch with warning}
\usage{
tcwarn(code_block, ...)
}
\arguments{
\item{code_block}{Code to run in Try Catch.}

\item{...}{Strings to concatenate to form the message that is returned.}
}
\description{
Easy Try/Catch implementation to return the same message as a warning on error or warning. Makes it easier to write tryCatches.
Author: Bryce Chamberlain. Tech review: Lindsay Smelzter.
}
\examples{
tryCatch({
   tcwarn({ NULL = 1 },'Cannot assign to NULL','variable') 
 }, 
 warning = function(e) print( e ) 
)

tryCatch({ 
   tcwarn({ as.numeric('abc') },'Issue in as.numeric()') 
 }, 
 warning = function(e) print( e )
)
}
