% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tobool.R
\name{tobool}
\alias{tobool}
\title{Convert to Logical/Boolean}
\usage{
tobool(x, preprocessed.values = NULL, nastrings = easyr::nastrings,
  ifna = c("return-unchanged", "error", "warning", "return-na"),
  verbose = TRUE, true.vals = c("true", "1", "t", "yes"),
  false.vals = c("false", "0", "f", "no"))
}
\arguments{
\item{x}{Value or vector to be converted.}

\item{preprocessed.values}{Strings need to have NAs set, lowercase and be trimmed before they can be checked. To avoid doing this multiple times, you can pass these processed values to the function.}

\item{nastrings}{Vector of characters to be considered NAs. todate will treat these like NAs. Defaults to the easyr::nastrings list.}

\item{ifna}{Action to take if NAs are created. 'return-unchanged'  returns the sent vector unchanged; 'warning' results in a warning and returns the converted vector with new NAs; 'error' results in an error.}

\item{verbose}{Choose to view messaging.}

\item{true.vals}{Values to consider as TRUE.}

\item{false.vals}{Values to consider as FALSE.}
}
\value{
Converted logical vector.
}
\description{
Flexible boolean conversion. 
Author: Bryce Chamberlain.
}
\examples{
tobool( c( 'true', 'FALSE', 0, 1, NA, 'yes', 'NO' ) )
}
