% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotEAT.R
\name{plotEAT}
\alias{plotEAT}
\title{Efficiency Analysis Trees Plot}
\usage{
plotEAT(object)
}
\arguments{
\item{object}{An \code{EAT} object.}
}
\value{
Plot object with the following elements for each node:
\itemize{
\item{id: node index.}
\item{R: error at the node.}
\item{n(t): number of observations at the node.}
\item{an input name: splitting variable.}
\item{y: output prediction.}
}
}
\description{
Plot a tree-structure for an Efficiency Analysis Trees model.
}
\examples{
\donttest{
simulated <- X2Y2.sim(N = 50, border = 0.2)
EAT_model <- EAT(data = simulated, x = c(1,2), y = c(3, 4))

plotEAT(EAT_model)
}

}
