% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objectives.R
\name{cappedMaximinObjective}
\alias{cappedMaximinObjective}
\title{Capped Maximin Constraint.}
\usage{
cappedMaximinObjective(
  nForms,
  itemValues,
  weight = 1,
  whichForms = seq_len(nForms),
  info_text = NULL,
  itemIDs = names(itemValues)
)
}
\arguments{
\item{nForms}{Number of forms to be created.}

\item{itemValues}{Item parameter/values for which the sum per test form should be constrained.}

\item{weight}{a weight for the real-valued variable(s). Useful when multiple constraints are combined. Should only be used if the implications are well understood.}

\item{whichForms}{An integer vector indicating which test forms should be constrained. Defaults to all the test forms.}

\item{info_text}{a character string of length 1, to be used in the \code{"info"}-attribute of the resulting \code{constraint}-object.}

\item{itemIDs}{a character vector of item IDs in correct ordering, or NULL.}
}
\value{
An object of class \code{"constraint"}.
}
\description{
Create \code{maximin}-constraints related to an item parameter/value. That is, the created
constraints can be used to maximize the minimal sum of the
item values (\code{itemValues}), while at the same time automatically setting
an ideal upper limit to the overflow. More specifically, the \code{capped minimax}
method described by Luo (2020) is used.
}
\examples{
# constraint that minimizes the maximum difference per test form value and a
#   target value of 0
cappedMaximinObjective(nForms = 2, itemValues = rep(-2:2, 2))

}
\references{
Xiao Luo (2020). Automated Test Assembly with Mixed-Integer Programming:
The Effects of Modeling Approaches and Solvers.
\emph{Journal of Educational Measurement}, 57(4), 547-565.
\doi{10.1111/jedm.12262}
}
