% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changeSPSSformat.R
\name{changeSPSSformat}
\alias{changeSPSSformat}
\title{Change SPSS format.}
\usage{
changeSPSSformat(GADSdat, varName, format)
}
\arguments{
\item{GADSdat}{\code{GADSdat} object imported via \code{eatGADS}.}

\item{varName}{Character string of variable names.}

\item{format}{A single string containing the new SPSS format, for example 'A25' or 'F10'.}
}
\value{
Returns the \code{GADSdat} object with changed meta data..
}
\description{
Change the SPSS format of a variable as part of a \code{GADSdat} or \code{all_GADSdat} object.
}
\details{
Applied to a \code{GADSdat} or \code{all_GADSdat} object, this function is a wrapper of \code{\link{getChangeMeta}} and \code{\link{applyChangeMeta}}.
}
\examples{
pisa2 <- changeSPSSformat(pisa, varName = "idstud",
                        format = "F10.0")


}
