% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractDataOld.R
\name{extractDataOld}
\alias{extractDataOld}
\title{Extract Data while merging linking errors.}
\usage{
extractDataOld(
  GADSdat,
  convertMiss = TRUE,
  convertLabels = "character",
  dropPartialLabels = TRUE,
  convertVariables = NULL
)
}
\arguments{
\item{GADSdat}{A \code{GADSdat} object.}

\item{convertMiss}{Should values coded as missing values be recoded to \code{NA}?}

\item{convertLabels}{If \code{"numeric"}, values remain as numerics. If \code{"factor"} or \code{"character"}, values are recoded to their labels. Corresponding variable type is applied.}

\item{dropPartialLabels}{Should value labels for partially labeled variables be dropped? If \code{TRUE}, the partial labels will be dropped. If \code{FALSE}, the variable will be converted to the class specified in \code{convertLabels}.}

\item{convertVariables}{Character vector of variables names, which labels should be applied to. If not specified (default), value labels are applied to all variables for which labels are available. Variable names not in the actual GADS are silently dropped.}
}
\value{
Returns a data frame.
}
\description{
Support for linking error data bases has been removed from \code{eatGADS}.
\code{extractDataOld} provides (for the time being) backwards compatibility, so linking errors can still be merged automatically.
}
\details{
See \code{\link{extractData}} for the current functionality.
}
