% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fac2dummies.R
\name{fac2dummies}
\alias{fac2dummies}
\title{Transform a factor variable to dummy variables.}
\usage{
fac2dummies(GADSdat, var)
}
\arguments{
\item{GADSdat}{A \code{data.frame} or \code{GADSdat} object.}

\item{var}{A character vector with the name of the factor variable.}
}
\value{
Returns a \code{GADSdat} containing the newly computed variables.
}
\description{
Convert a factor variable with n levels to n dummy variables.
}
\details{
Newly created variables are named as the original variable with the suffix \code{"_a"}, \code{"_b"} and so on. Variable labels
are created by using the original variable label (if available) and adding the value label of the corresponding level.
All missing codes are forwarded to all dummy variables.
}
\examples{
## create an example GADSdat
suppressMessages(gads <- import_DF(iris))

## transform factor variable
gads2 <- fac2dummies(gads, var = "Species")


}
