% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeEmptyValLabels.R
\name{removeEmptyValLabels}
\alias{removeEmptyValLabels}
\title{Remove unused value labels and missing tags.}
\usage{
removeEmptyValLabels(GADSdat, vars, whichValLabels = c("miss", "valid", "all"))
}
\arguments{
\item{GADSdat}{\code{GADSdat} object imported via \code{eatGADS}.}

\item{vars}{Character string of variable names.}

\item{whichValLabels}{Should unused missing value tags and labels (\code{"miss"}), unused value labels for non-missing values (\code{"valid"}), or both (\code{"all"}) be removed?}
}
\value{
Returns the \code{GADSdat} object with changed meta data.
}
\description{
Remove unused value labels and missing tags of a variable as part of a \code{GADSdat} object.
}
\examples{
gads <- import_DF(data.frame(v1 = 1))
gads <- changeMissings(gads, varName = "v1", value = c(-99, -98), missings = c("miss", "miss"))
gads <- changeValLabels(gads, varName = "v1", value = c(-99), valLabel = c("not reached"))

gads2 <- removeEmptyValLabels(gads, vars = "v1")
}
