% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{load_config}
\alias{load_config}
\title{Load eBird Status and Trends configuration file}
\usage{
load_config(path)
}
\arguments{
\item{path}{character; directory that the Status and Trends data for a given
species was downloaded to. This path is returned by \code{ebirdst_download()}
or \code{get_species_path()}.}
}
\value{
A list with the run configuration parameters.
}
\description{
Load the configuration file for an eBird Status and Trends runs. This
configuration file is mostly for internal use and contains a variety of
parameters used in the modeling process.
}
\examples{
\dontrun{
# download example data
path <- ebirdst_download("example_data")
# or get the path if you already have the data downloaded
path <- get_species_path("example_data")

# load configuration file
cfg <- load_config(path)
}
}
