% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{load_ranges}
\alias{load_ranges}
\title{Load seasonal eBird Status and Trends range polygons}
\usage{
load_ranges(path, resolution = c("mr", "lr"), smoothed = TRUE)
}
\arguments{
\item{path}{character; directory that the Status and Trends data for a given
species was downloaded to. This path is returned by \code{ebirdst_download()}
or \code{get_species_path()}.}

\item{resolution}{character; the raster resolution from which the range
polygons were derived.}

\item{smoothed}{logical; whether smoothed or unsmoothed ranges should be
loaded.}
}
\value{
An \code{sf} update containing the seasonal range boundaries, with each
season provided as a different feature.
}
\description{
Range polygons are defined as the boundaries of non-zero seasonal relative
abundance estimates, which are then (optionally) smoothed to produce more
aesthetically pleasing polygons using the \code{smoothr} package.
}
\examples{
\dontrun{
# download example data
path <- ebirdst_download("example_data")
# or get the path if you already have the data downloaded
path <- get_species_path("example_data")

# load smoothed ranges
# note that only low res data are provided for the example data
ranges <- load_range(path, resolution = "lr")
}
}
