% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebv_metadata.R
\name{ebv_metadata}
\alias{ebv_metadata}
\title{Create the metadata file (json) for the EBV netCDF creation}
\usage{
ebv_metadata(
  outputpath,
  title,
  summary,
  references = NULL,
  source,
  project_name = NULL,
  project_url = NULL,
  date_created,
  creator_name,
  creator_email = NULL,
  creator_institution,
  contributor_name = NULL,
  license,
  comment = NULL,
  ebv_class,
  ebv_name,
  ebv_scenario_classification_name = NULL,
  ebv_scenario_classification_version = NULL,
  ebv_scenario_classification_url = NULL,
  ebv_spatial_scope,
  ebv_spatial_description = NULL,
  ebv_domain,
  coverage_content_type,
  ebv_entity_type,
  ebv_entity_scope,
  ebv_entity_classification_name = NULL,
  ebv_entity_classification_url = NULL,
  time_coverage_start,
  time_coverage_end,
  time_coverage_resolution,
  metric = list(standard_name = "", long_name = "", units = ""),
  scenario = list(standard_name = "", long_name = ""),
  overwrite = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{outputpath}{Character. Outputpath of the text-file (JSON format)
containing the metadata. File ending: *.json}

\item{title}{Character. A short phrase or sentence describing the dataset.}

\item{summary}{Character. A paragraph describing the dataset, analogous to an
abstract for a paper. Maximum character length: 1500.}

\item{references}{Character. Optional. DOIs (URLs) that describe the data or
methods used to produce it. Multiple DOIs can be given in a vector.}

\item{source}{Character. The method of production of the original data. If it
was model-generated, source should name the model and its version. If it is
observational, source should characterize it. Corresponding term in the EBV
Data Portal: 'methods'.}

\item{project_name}{Character. Optional. The name of the project principally
responsible for originating this data.}

\item{project_url}{Character. Optional. The URL of the project.}

\item{date_created}{Character. The date on which this version of the data was
created in YYYY-MM-DD format.}

\item{creator_name}{Character. The name of the person principally responsible
for creating this data.}

\item{creator_email}{Character. Optional. The email address of the person principally
responsible for creating this data.}

\item{creator_institution}{Character. The institution of the creator; should
uniquely identify the creator's institution.}

\item{contributor_name}{Character. Optional. The name of any individuals, projects, or
institutions that contributed to the creation of this data. Corresponding
term in the EBV Data Portal: 'Co-creators'. Multiple contributors can be
given in a vector.}

\item{license}{Character. License of the dataset. Will be stored in the
netCDF as the URL to the CC license. Choose one of: 'CC0', 'CC BY', 'CC
BY-SA', 'CC BY-NC', 'CC BY-NC-SA', 'CC BY-ND', 'CC BY-NC-ND'.}

\item{comment}{Character.  Optional. Miscellaneous information about the data, not
captured elsewhere.}

\item{ebv_class}{Character. EBV Class of the data set. One of: 'Genetic
composition', 'Species populations', 'Species traits', 'Community
composition', 'Ecosystem functioning', 'Ecosystem structure', 'Ecosystem
services'. For more info see note.}

\item{ebv_name}{Character. EBV Name of the data set. The possible options
depend on the EBV Class. One of: 'Intraspecific genetic diversity',
'Genetic differentiation', 'Effective population size', 'Inbreeding',
'Species distributions', 'Species abundances', 'Morphology', 'Physiology',
'Phenology', 'Movement', 'Community abundance', 'Taxonomic and phylogenetic
diversity', 'Trait diversity', 'Interaction diversity', 'Primary
productivity', 'Ecosystem phenology', 'Ecosystem disturbances', 'Live cover
fraction', 'Ecosystem distribution', 'Ecosystem Vertical Profile',
'Pollination' For more info see note.}

\item{ebv_scenario_classification_name}{Character. Optional. Name of the classification
system used for the scenarios.}

\item{ebv_scenario_classification_version}{Character. Optional. Version of the
classification system used for the scenarios.}

\item{ebv_scenario_classification_url}{Character. Optional. URL of the classification
system used for the scenarios.}

\item{ebv_spatial_scope}{Character. Spatial scope of the data set. One of:
'Continental/Regional', 'National', 'Sub-national/Local' or 'Global'.}

\item{ebv_spatial_description}{Character. Specific information about the
spatial scope. Mandatory if spatial scope is not Global.}

\item{ebv_domain}{Character. Environmental domain of the data set. Choose one
or several of: 'Terrestrial', 'Marine' or 'Freshwater'. Multiple domains
can be given in a vector.}

\item{coverage_content_type}{Character. Describes the source of the data
based on an ISO 19115-1 code. Choose one or several of: 'image',
'thematicClassification', 'physicalMeasurement', 'auxiliaryInformation',
'qualityInformation', 'referenceInformation', 'modelResult', or
'coordinate'. Multiple types can be given in a vector.}

\item{ebv_entity_type}{Character. EBV entity type. This is a free entry
field. Still, if one of the following terms fits your entity scope please
use: 'Species', 'Communities', 'Ecosystems' or 'None'.}

\item{ebv_entity_scope}{Character. Specifies the entity scope in more detail,
e.g., 'African great apes'. If the entity type is 'None' this term is not
applied to the metadata.}

\item{ebv_entity_classification_name}{Character. Optional. Name of the classification
system used for the entity types.}

\item{ebv_entity_classification_url}{Character. Optional. URL of the classification
system used for the entity types.}

\item{time_coverage_start}{Character. Start date of the time span covered by
the dataset in YYYY-MM-DD format.}

\item{time_coverage_end}{Character. End date of the time span covered by the
dataset in YYYY-MM-DD format.}

\item{time_coverage_resolution}{Character. Describes the targeted time period
between each value in the data set (ISO 8601:2004 date format). Provide the
definition of your temporal resolution in the ISO 8601:2004 duration format
P(YYYY)-(MM)-(DD). Examples: decadal: 'P0010-00-00', daily: 'P0000-00-01',
single timestep: 'P0000-00-00' and irregular time intervals: 'Irregular'.
For the latter the timesteps can be directly defined when using
\code{\link[=ebv_create]{ebv_create()}} (\code{timesteps} argument).}

\item{metric}{List. Metric attributes defined accordingly:
list(standard_name='', long_name='', units=''). If you have several metrics
give a list of lists, e.g. for two: list(list(standard_name='',
long_name='', units=''),list(standard_name='', long_name='', units=''))
At least one metric is mandatory.}

\item{scenario}{List. Optional. Scenario attributes defined accordingly:
list(standard_name='', long_name=''). If you have several scenarios give a
list of lists, e.g. for two: list(list(standard_name='',
long_name=''),list(standard_name='', long_name='')). It is not mandatory to
have a scenario.}

\item{overwrite}{Logical. Default: FALSE. Set to TRUE to overwrite the output
file defined by 'outputpath'.}

\item{verbose}{Logical. Default: TRUE. Turn off additional prints and
warnings by setting it to FALSE.}
}
\value{
Returns the outputpath of the JSON file with the metadata.
}
\description{
This function collects the metadata terms of the EBV netCDF to
create and collects them in a text file in JSON format. Use
\code{\link[=ebv_create]{ebv_create()}} with the output file of this function to create
your EBV netCDF. During the actual creation you will be asked for more
information regarding the spatial resolution, CRS etc.
}
\details{
See EBV Classes and their corresponding EBV Names:\tabular{ll}{
   \strong{EBV Class} \tab \strong{EBV Names} \cr
   Genetic composition \tab 'Intraspecific genetic diversity', 'Genetic differentiation','Effective population size', 'Inbreeding' \cr
   Species populations \tab 'Species distributions', 'Species abundances' \cr
   Species traits \tab 'Morphology', 'Physiology', 'Phenology', 'Movement' \cr
   Community composition \tab 'Community abundance', 'Taxonomic and phylogenetic diversity', 'Trait diversity', 'Interaction diversity' \cr
   Ecosystem functioning \tab 'Primary productivity', 'Ecosystem phenology', 'Ecosystem disturbances' \cr
   Ecosystem structure \tab 'Live cover fraction', 'Ecosystem distribution', 'Ecosystem Vertical Profile' \cr
   Ecosystem services \tab 'Pollination', 'other' \cr
}
}
\note{
\strong{Metadata Conventions:} The metadata termns of the EBV netCDFs
are based on
\href{https://cfconventions.org/Data/cf-conventions/cf-conventions-1.8/cf-conventions.html}{CF
1.8} and
\href{https://wiki.esipfed.org/Attribute_Convention_for_Data_Discovery_1-3}{ACDD
1.3} Conventions.
Find more help in the
\href{https://portal.geobon.org/downloads/pdf/how_to_ebv-portal.pdf}{How-To}
on the EBV Portal Website.\cr\strong{EBV Class:} The EBV Class is GEO BON's
classification system for biodiversity monitoring. It categorizes and
organizes essential ecological variables across scales and biological
levels. This standardized framework helps identify and prioritize key
variables representing biodiversity aspects like species composition,
population dynamics, ecosystem functioning, and habitat quality.
\cr\strong{EBV Name:} The EBV Name is a unique identifier for a specific
variable in the EBV Class, representing a distinct aspect of biodiversity.
It helps identify and categorize measured or monitored biodiversity
information. The EBV Name reflects the ecological attribute being assessed,
such as "Species Richness," "Population Abundance," "Functional Diversity,"
"Habitat Fragmentation," or "Ecosystem Productivity".
\cr\strong{Authorship:} Besides the creator and the contributors there is a
third metadata term regarding authorship: the 'publisher'. This is the
person that logs into the EBV Data Portal and uploads the dataset. This
person's personal data is automatically added to the metadata from the
account information.
}
\examples{
#create minimal metadata
\dontrun{
ebv_metadata(outputpath=out,
  overwrite = TRUE,
  title = 'Not a real title',
  summary = 'Summary summary summary',
  source = 'this was created by doing...',
  date_created = as.Date('2024-07-10'),
  creator_name = 'Name Name',
  creator_institution = 'lame name',
  license = 'CC0',
  ebv_class = 'Genetic composition',
  ebv_name = 'Intraspecific genetic diversity',
  ebv_spatial_scope = 'National',
  ebv_spatial_description = 'Finland',
  ebv_domain = 'Terrestrial',
  ebv_entity_type = 'Species',
  ebv_entity_scope = '50 mammal species',
  coverage_content_type = c('modelResult'),
  time_coverage_start = as.Date('1900-01-01'),
  time_coverage_end =as.Date('1950-01-01'),
  time_coverage_resolution = 'P0010-00-00',
  metric = list(list(standard_name='relative change of habitat',
  long_name='relative change to year 1800', units='percentage'),
              list(standard_name='absolute change habitat',
              long_name='absolute change since year 1800',
              units='square kilometers')),
  scenario = list(list(standard_name='SSP1xRCP2.6 LU',
                long_name='Global Sustainability (SSP1xRCP2.6), with only effects of land-use.'),
                list(standard_name='SSP3xRCP6.0 LU',
                long_name='Regional Rivalry (SSP3xRCP6.0), with only effects of land-use')),
  scenario_classification_name = 'SSP-RCP',
  ebv_scenario_classification_version = 'LUH2, CMIP5/ISIMIP2a',
  verbose = TRUE
)
}
}
