% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecd-moment-generic.R
\docType{methods}
\name{moment.ecd}
\alias{moment}
\alias{moment,ecd-method}
\alias{moment.ecd}
\title{Compute the moment of ecd via integration}
\usage{
\method{moment}{ecd}(object, order, center = FALSE, asymp.lower = -Inf,
  asymp.upper = Inf, verbose = FALSE)

moment(object, order, center = FALSE, asymp.lower = -Inf,
  asymp.upper = Inf, verbose = FALSE)

\S4method{moment}{ecd}(object, order, center = FALSE, asymp.lower = -Inf,
  asymp.upper = Inf, verbose = FALSE)
}
\arguments{
\item{object}{an object of ecd class}

\item{order}{numeric. Order of the moment to be computed}

\item{center}{logical. If set to \code{TRUE}, calculate central moments.
Default: \code{FALSE}.}

\item{asymp.lower}{numeric, lower bound for asymptotic statistics, default: \code{-Inf}.}

\item{asymp.upper}{numeric, upper bound for asymptotic statistics, default: \code{Inf}.}

\item{verbose}{logical, display timing information, for debugging purpose.}
}
\value{
Numeric. The moment.
}
\description{
Compute the moment of ecd via integration between \code{-Inf} and \code{Inf}.
The \code{asymp.lower} and \code{asymp.upper} parameters are used for
asymptotic statistics, to study the effect of finite observations.
}
\examples{
d <- ecd()
moment(d, 2)
}
\author{
Stephen H. Lihn
}
\keyword{moment}

