% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecd-asymp-stats-method.R
\name{ecd.asymp_stats}
\alias{ecd.asymp_kurtosis}
\alias{ecd.asymp_stats}
\title{Compute asymptotic statistics of an ecd object}
\usage{
ecd.asymp_stats(object, q)

ecd.asymp_kurtosis(object, q)
}
\arguments{
\item{object}{an object of ecd class with quantile}

\item{q}{numeric vector of quantiles}
}
\value{
a list of stats list, or a vector of kurtosis
}
\description{
The main API for asymptotic statistics.
It follows the same definition of moments, except the integral of PDF
is limited to a range of quantile. That is to truncate the tails.
The asymptotic kurtosis is also called truncated kurtosis.
}
\examples{
\dontrun{
    d <- ecd(1,1, with.quantile=TRUE)
    q <- 0.01
    ecd.asymp_stats(d,q)
    ecd.asymp_kurtosis(d,q)
}
}
\keyword{statistics}

