% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecd-class.R
\docType{class}
\name{ecd-class}
\alias{ecd-class}
\title{The ecd class}
\description{
This S4 class is the major object class for elliptic distribution.
It stores the ecd parameters, numerical constants that facilitates
quadpack integration, statistical attributes, and optionally,
an internal structure for the quantile function.
}
\section{Slots}{

\describe{
\item{\code{call}}{The match.call slot}

\item{\code{alpha,gamma,sigma,beta,mu}}{a length-one numeric.
These are core ecd parameters.}

\item{\code{cusp}}{a length-one numeric as cusp indicator. 
0: not a cusp; 
1: cusp specified by \code{alpha}; 
2: cusp specified by \code{gamma}.}

\item{\code{lambda}}{a length-one numeric, the leading exponent for the special model, default is 3.}

\item{\code{R,theta}}{a length-one numeric. These are derived ecd parameters in polar coordinate.}

\item{\code{use.mpfr}}{logical, internal flag indicating whether to use mpfr.}

\item{\code{const}}{A length-one numeric as the integral of \eqn{exp(y(x))} that normalizes the PDF.}

\item{\code{const_left_x}}{A length-one numeric marking the left point of PDF integration.}

\item{\code{const_right_x}}{A length-one numeric marking the right point of PDF integration.}

\item{\code{stats}}{A list of statistics, see \code{ecd.stats} for more information.}

\item{\code{quantile}}{An object of ecdq class, for quantile calculation.}

\item{\code{model}}{A vector of four strings representing internal classification:
\code{long_name.skew}, code{long_name},
\code{short_name.skew}, \code{short_name}.
This slot doesn't have formal use yet.}
}}

\keyword{class}
\keyword{constructor}
