% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecld-sged-method.R
\name{ecld.sged_const}
\alias{ecld.sged_const}
\alias{ecld.sged_cdf}
\alias{ecld.sged_moment}
\alias{ecld.sged_mgf}
\alias{ecld.sged_imgf}
\alias{ecld.sged_ogf}
\title{The integral solutions of SGED}
\usage{
ecld.sged_const(object)

ecld.sged_cdf(object, x)

ecld.sged_moment(object, order)

ecld.sged_mgf(object, t = 1)

ecld.sged_imgf(object, k, t = 1, otype = "c")

ecld.sged_ogf(object, k, otype = "c")
}
\arguments{
\item{object}{an sged object of ecld class}

\item{x}{a numeric vector of \code{x}}

\item{order}{numeric, order of the moment to be computed}

\item{t}{numeric, for MGF and IMGF}

\item{k}{a numeric vector of log-strike}

\item{otype}{character, specifying option type:
\code{c} (default) or \code{p}.}
}
\value{
numeric
}
\description{
These integrals are mainly used as validation to analytic solutions.
If you must use them, be mindful of their slower speeds.
}
\examples{
ld <- ecld(3)
ecld.const(ld)
}
\author{
Stephen H-T. Lihn
}
\keyword{sged}
