% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecd-polar-constructor.R
\name{ecd.polar}
\alias{ecd.polar}
\title{Polar constructor of ecd class}
\usage{
ecd.polar(
  R = NaN,
  theta = NaN,
  sigma = 1,
  beta = 0,
  mu = 0,
  cusp = 0,
  with.stats = TRUE,
  with.quantile = FALSE,
  bare.bone = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{R}{numeric, the radius parameter. Default is \code{NaN}.}

\item{theta}{numeric, the angle parameter. Default: \code{NaN}.}

\item{sigma}{numeric, the scale parameter. Must be positive. Default: 1.}

\item{beta}{numeric, the skewness parameter. Default: 0.}

\item{mu}{numeric, the location parameter. Default: 0.}

\item{cusp}{logical, indicate type of cusp (0,1,2).}

\item{with.stats}{logical, also calculate statistics, default is \code{TRUE}.}

\item{with.quantile}{logical, also calculate quantile data, default is \code{FALSE}.}

\item{bare.bone}{logical, skip both const and stats calculation, default is \code{FALSE}.
This for debug purpose for issues on integrating \eqn{e^y(x)}.}

\item{verbose}{logical, display timing information, for debugging purpose, default is \code{FALSE}.}
}
\value{
The ecd class
}
\description{
Construct an ecd class by specifying R and theta. They are converted to 
\code{alpha} and \code{gamma}, then passed onto the ecd constructor.
}
\examples{
d <- ecd.polar(R=1, theta=0.5*pi)
}
\author{
Stephen H. Lihn
}
\keyword{constructor}
\keyword{ecd}
