% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/levy-domain-coloring-method.R
\name{levy.domain_coloring}
\alias{levy.domain_coloring}
\title{Domain coloring of Laplace kernel of lambda distribution}
\usage{
levy.domain_coloring(t, rec, n = 200, lambda = 4)
}
\arguments{
\item{t}{numeric or complex}

\item{rec}{numeric, define the rectangle of plot in the order of (x1, x2, y1, y2)}

\item{n}{numeric, number of points per axis. Default is 200. Use 1000 for better resolution.}

\item{lambda}{numeric. Default is 4, and is the only value allowed.}
}
\value{
return value of call to \code{grid.arrange()}
}
\description{
Domain coloring on the complex plane of Laplace kernel of lambda distribution, 
\code{exp(ixt) P(x)}, where P(x) is the PDF of a lambda distribution.
This is a visualization utility to get insight how the Laplace transform works
for lambda distribution. The behavior on the complex plane is deeply associated
with the MGF, the skew Levy distribution, and the SaS distribution.
}
\examples{
\dontrun{
  levy.domain_coloring(0.1, c(-25, 50, -50, 50))
  levy.domain_coloring(0.1i, c(-25, 25, -25, 25))
}

}
\author{
Stephen H. Lihn
}
\keyword{Domain-Coloring}
