% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lamp-qsl-analytic-method.R
\name{qsl_kurtosis_analytic}
\alias{qsl_kurtosis_analytic}
\alias{qsl_skewness_analytic}
\alias{qsl_variance_analytic}
\alias{qsl_std_pdf0_analytic}
\alias{qsl_pdf_integrand_analytic}
\title{Analytic solutions on the statistics of quartic stable lambda distribution}
\usage{
qsl_kurtosis_analytic(t = 1, nu0 = 0, theta = 1, convo = 1, beta.a = 0)

qsl_skewness_analytic(t = 1, nu0 = 0, theta = 1, convo = 1, beta.a = 0)

qsl_variance_analytic(t = 1, nu0 = 0, theta = 1, convo = 1, beta.a = 0)

qsl_std_pdf0_analytic(t = 1, nu0 = 0, theta = 1, convo = 1, beta.a = 0)

qsl_pdf_integrand_analytic(
  x,
  nu,
  t = 1,
  nu0 = 0,
  theta = 1,
  convo = 1,
  beta.a = 0,
  mu = 0
)
}
\arguments{
\item{t}{numeric, the time parameter, where the variance is t, default is 1.}

\item{nu0}{numeric, the location parameter, default is 0.}

\item{theta}{numeric, the scale parameter, default is 1.}

\item{convo}{numeric, the convolution number, default is 1.}

\item{beta.a}{numeric, the skewness parameter, default is 0. This number is annualized by sqrt(t).}

\item{x}{numeric, vector of responses.}

\item{nu}{numeric, vector of nu in the pdf integrand, starting from 0 (not nu0).}

\item{mu}{numeric, the location parameter, default is 0.}
}
\value{
numeric
}
\description{
Several analytic solutions on the statistics of quartic stable lambda distribution (QSLD) are 
implemented. These functions provide precise validation on the distribution.
}
\examples{
  # obtain the variance for SPX 1-day distribution
  var <- qsl_variance_analytic(t=1/250, nu0=6.92/100, theta=1.17/100, convo=2, beta=-1.31)
}
\references{
For more detail, see Appendix C of 
  Stephen Lihn (2017). 
  \emph{A Theory of Asset Return and Volatility 
  under Stable Law and Stable Lambda Distribution}.
  SSRN: 3046732, \url{https://papers.ssrn.com/sol3/papers.cfm?abstract_id=3046732}.
}
\author{
Stephen H-T. Lihn
}
\keyword{stable-Lambda}
