% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{e_tooltip}
\alias{e_tooltip}
\alias{e_tooltip_item_formatter}
\alias{e_tooltip_pie_formatter}
\alias{e_tooltip_pointer_formatter}
\title{Tooltip}
\usage{
e_tooltip(e, trigger = c("item", "axis"), formatter = NULL, ...)

e_tooltip_item_formatter(style = c("decimal", "percent", "currency"),
  digits = 0, locale = NULL, currency = "USD")

e_tooltip_pie_formatter(style = c("decimal", "percent", "currency"),
  digits = 0, locale = NULL, currency = "USD", ...)

e_tooltip_pointer_formatter(style = c("decimal", "percent", "currency"),
  digits = 0, locale = NULL, currency = "USD")
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}}.}

\item{trigger}{What triggers the tooltip, one of \code{item} or \code{item}.}

\item{formatter}{Item and Pointer formatter as returned 
by \code{\link{e_tooltip_item_formatter}}, \code{\link{e_tooltip_pointer_formatter}}, 
\code{\link{e_tooltip_pie_formatter}}.}

\item{...}{Any other option to pass, check See Also section.}

\item{style}{Formatter style, one of \code{decimal}, \code{percent}, or \code{currency}.}

\item{digits}{Number of decimals.}

\item{locale}{Locale, if \code{NULL} then it is inferred from \code{Sys.getlocale}.}

\item{currency}{Currency to to display.}
}
\description{
Customise tooltip
}
\section{Formatters}{

\itemize{
  \item{\code{\link{e_tooltip_pie_formatter}}: special helper for \code{\link{e_pie}}.}
  \item{\code{\link{e_tooltip_item_formatter}}: general helper, this is passed to the \href{https://ecomfe.github.io/echarts-doc/public/en/option.html#tooltip.formatter}{tooltip \code{formatter}}.}
  \item{\code{\link{e_tooltip_pointer_formatter}}: helper for pointer, this is passed to the
  \href{https://ecomfe.github.io/echarts-doc/public/en/option.html#tooltip.axisPointer.label}{\code{label} parameter under \code{axisPointer}}.}
}
}

\examples{
# basic
USArrests \%>\% 
  e_charts(Assault) \%>\% 
  e_scatter(Murder) \%>\% 
  e_tooltip()
  
# formatter
cars \%>\% 
  dplyr::mutate(
    dist = dist / 120
  ) \%>\% 
  e_charts(speed) \%>\% 
  e_scatter(dist, symbol_size = 5) \%>\% 
  e_tooltip(
    formatter = e_tooltip_item_formatter("percent")
  )

# axis pointer
cars \%>\% 
  e_charts(speed) \%>\% 
  e_scatter(dist, symbol_size = 5) \%>\% 
  e_tooltip(
    formatter = e_tooltip_pointer_formatter("currency"), 
    axisPointer = list(
      type = "cross"
    )
  )

}
\seealso{
\href{https://ecomfe.github.io/echarts-doc/public/en/option.html#tooltip}{Additional arguments}
}
