% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R, R/add_.R
\name{e_scatter_3d}
\alias{e_scatter_3d}
\alias{e_scatter_3d_}
\title{Scatter 3D}
\usage{
e_scatter_3d(e, y, z, color, size, bind, coord_system = "cartesian3D",
  name = NULL, rm_x = TRUE, rm_y = TRUE, legend = FALSE, ...)

e_scatter_3d_(e, y, z, color = NULL, size = NULL, bind = NULL,
  coord_system = "cartesian3D", name = NULL, rm_x = TRUE,
  rm_y = TRUE, legend = FALSE, ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}}.}

\item{y, z}{Coordinates.}

\item{color, size}{Color and Size of bubbles.}

\item{bind}{Binding.}

\item{coord_system}{Coordinate system to use, one of \code{geo3D}, \code{globe}, or \code{cartesian3D}.}

\item{name}{name of the serie.}

\item{rm_x, rm_y}{Whether to remove x and y axis, defaults to \code{TRUE}.}

\item{legend}{Whether to add serie to legend.}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
Add 3D scatter.
}
\examples{
v <- LETTERS[1:10]
matrix <- data.frame(
  x = sample(v, 300, replace = TRUE), 
  y = sample(v, 300, replace = TRUE), 
  z = rnorm(300, 10, 1),
  color = rnorm(300, 10, 1),
  size = rnorm(300, 10, 1),
  stringsAsFactors = FALSE
) \%>\% 
  dplyr::group_by(x, y) \%>\% 
  dplyr::summarise(
    z = sum(z),
    color = sum(color),
    size = sum(size)
  ) \%>\% 
  dplyr::ungroup() 
  
matrix \%>\% 
  e_charts(x) \%>\% 
  e_scatter_3d(y, z, size, color) \%>\% 
  e_visual_map(
    min = 1, max = 100,
    inRange = list(symbolSize = c(1, 30)), # scale size
    dimension = 3 # third dimension 0 = x, y = 1, z = 2, size = 3
  ) \%>\% 
  e_visual_map(
    min = 1, max = 100,
    inRange = list(color = c('#bf444c', '#d88273', '#f6efa6')), # scale colors
    dimension = 4, # third dimension 0 = x, y = 1, z = 2, size = 3, color = 4
    bottom = 300 # padding to avoid visual maps overlap
  )
  
airports <- read.csv(
  paste0("https://raw.githubusercontent.com/plotly/datasets/",
         "master/2011_february_us_airport_traffic.csv")
)

airports \%>\% 
  e_charts(long) \%>\% 
  e_globe(
    globeOuterRadius = 100
  ) \%>\% 
  e_scatter_3d(lat, cnt, coord_system = "globe", blendMode = 'lighter') \%>\% 
  e_visual_map(inRange = list(symbolSize = c(1, 10)))
  
# timeline
airports \%>\% 
  group_by(state) \%>\% 
  e_charts(long, timeline = TRUE) \%>\% 
  e_globe(
    globeOuterRadius = 100
  ) \%>\% 
  e_scatter_3d(lat, cnt, coord_system = "globe", blendMode = 'lighter') \%>\% 
  e_visual_map(inRange = list(symbolSize = c(1, 10)))

}
\seealso{
\href{http://echarts.baidu.com/option-gl.html#series-scatter3D}{Additional arguments}
}
