% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{e_format_axis}
\alias{e_format_axis}
\alias{e_format_x_axis}
\alias{e_format_y_axis}
\title{Formatters}
\usage{
e_format_axis(e, axis = "y", suffix = NULL, prefix = NULL, ...)

e_format_x_axis(e, suffix = NULL, prefix = NULL, ...)

e_format_y_axis(e, suffix = NULL, prefix = NULL, ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{axis}{Axis to apply formatter to.}

\item{suffix, prefix}{Suffix and prefix of label.}

\item{...}{Any other arguments to pass to \code{\link{e_axis}}.}
}
\description{
Simple formatters as helpers.
}
\examples{
# Y = \%
df <- data.frame(
  x = 1:10,
  y = round(
    runif(10, 1, 100), 2
  )
)

df \%>\%
  e_charts(x) \%>\%
  e_line(y) \%>\%
  e_format_y_axis(suffix = "\%") \%>\%
  e_format_x_axis(prefix = "A")
}
