% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R, R/add_.R
\name{e_parallel}
\alias{e_parallel}
\alias{e_parallel_}
\title{Parallel}
\usage{
e_parallel(e, ..., name = NULL, rm_x = TRUE, rm_y = TRUE, opts = list())

e_parallel_(e, ..., name = NULL, rm_x = TRUE, rm_y = TRUE, opts = list())
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{...}{Columns to select from the data passed to \code{\link{e_charts}}.}

\item{name}{name of the serie.}

\item{rm_x, rm_y}{Whether to remove x and y axis, defaults to \code{TRUE}.}

\item{opts}{A list of additional options to pass to the serie.}
}
\description{
Draw parallel coordinates.
}
\examples{
df <- data.frame(
  price = rnorm(5, 10),
  amount = rnorm(5, 15),
  letter = LETTERS[1:5]
)

df |>
  e_charts() |>
  e_parallel(price, amount, letter, opts = list(smooth = TRUE))
}
\seealso{
\href{https://echarts.apache.org/en/option.html#series-parallel}{Additional arguments}
}
