% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echoice2.R
\name{ec_dem_summarise}
\alias{ec_dem_summarise}
\alias{ec_dem_summarize}
\title{Summarize posterior draws of demand}
\usage{
ec_dem_summarise(de,quantiles)

ec_dem_summarize(de, quantiles = c(0.05, 0.95))
}
\arguments{
\item{de}{demand draws}

\item{quantiles}{Quantiles for Credibility Intervals (default: 90\% interval)}
}
\value{
Summary of demand predictions
}
\description{
Adds summaries of posterior draws of demand to tibble.
(using the new demand draw format)
}
\examples{
\donttest{
data(icecream)
#run MCMC sampler (use way more than 10 draws for actual use)
icecream_est <- icecream \%>\% dplyr::filter(id<10) \%>\% vd_est_vdm(R=10, keep=1)
#Generate demand predictions
icecream_predicted_demand=
 icecream \%>\% dplyr::filter(id<10) \%>\%   
   vd_dem_vdm(icecream_est)
#aggregate
brand_lvl_pred_demand <-
 icecream_predicted_demand \%>\% ec_dem_aggregate("Brand")
#summarise
brand_lvl_pred_demand \%>\% ec_dem_summarise()
}

}
